<div class="row g-4 justify-content-center pt-5">
    <div class="col-lg-6">
        <div class="dashboard-card p-4 p-md-5 text-center">
            <div class="d-flex flex-column align-items-center mb-5">
                <div class="feature-icon small bg-primary bg-opacity-10 mb-3" style="width: 80px; height: 80px;">
                    <i class="fas fa-envelope-open-text text-gradient" style="font-size: 2.22rem;"></i>
                </div>
                <h2 class="text-white mb-2 uppercase tracking-widest">Account Activation</h2>
                <p class="text-secondary small">Thank you for joining us! Please enter the activation code sent to your email to unlock all features.</p>
            </div>

            <?php if(isset($activation_message)) echo '<div class="alert alert-info border-0 bg-info bg-opacity-10 text-info p-3 rounded-4 mb-4 small">' . $activation_message . '</div>'; ?>

            <form method="post" action="<?= site_url('/verify') ?>" class="mt-4">
                <div class="mb-4 text-start">
                    <label class="text-secondary small text-uppercase fw-bold mb-2 d-block">Activation Code</label>
                    <div class="input-group">
                        <span class="input-group-text border-0 bg-white bg-opacity-5 text-secondary px-3"><i class="fas fa-key small"></i></span>
                        <input type="text" name="activation_code" class="form-control border-0 bg-white bg-opacity-5 text-white p-3 font-monospace tracking-widest" 
                               placeholder="Paste your code here" required>
                    </div>
                </div>

                <div class="w-100">
                    <button type="submit" class="btn-primary-custom w-100 py-3 rounded-pill shadow-lg fw-bold">
                        <i class="fas fa-check-circle me-2"></i> Activate My Account
                    </button>
                </div>
            </form>
            
            <p class="text-secondary smaller mt-4 opacity-75">Didn't receive a code? <a href="#" class="text-primary text-decoration-none">Resend Email</a></p>
        </div>
    </div>
</div>

<style>
    .font-monospace { font-family: 'JetBrains Mono', monospace !important; }
    .smaller { font-size: 0.75rem; }
</style>
