<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= isset($page) ? $page : 'Home' ?> | <?= $settings['name'] ?></title>
    <meta content="<?= $settings['description'] ?>" name="description" />
    <link rel="shortcut icon" href="<?= base_url('assets/images/favicon.ico') ?>">

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&family=Outfit:wght@400;500;600;700;800&display=swap" rel="stylesheet">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- Bootstrap -->
    <link href="<?= base_url('theme/libs/bootstrap/css/bootstrap.min.css') ?>" rel="stylesheet">

    <!-- Animate.css -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">

    <!-- Main CSS -->
    <link rel="stylesheet" href="<?= base_url('theme/css/style.css') ?>">

    <style>
        /* Modern UI Architecture Enhancements */
        :root {
            --sidebar-width: 280px;
        }
        
        body {
            font-family: 'Outfit', sans-serif;
            background-color: var(--dark-bg);
            color: var(--text-primary);
        }
        
        .text-gradient {
            background: var(--primary-gradient);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        /* Animations */
        .hover-lift {
            transition: var(--transition);
        }
        .hover-lift:hover {
            transform: translateY(-5px);
            box-shadow: var(--shadow-large);
        }

        /* Sidebar for logged in users */
        #main-wrapper {
            display: flex;
            min-height: 100vh;
            flex-direction: column;
            transition: var(--transition);
        }

        #content-wrapper {
            flex: 1;
            display: flex;
        }

        <?php if($this->session->has_userdata('VUID')) { ?>
        .navbar {
            padding: 0.6rem 0 !important;
            position: sticky !important;
            top: 0;
            z-index: 1010;
            margin-bottom: 25px !important;
            background: rgba(10, 10, 15, 0.95) !important;
            border-bottom: 1px solid var(--border-color) !important;
            box-shadow: 0 4px 20px rgba(0,0,0,0.4) !important;
            backdrop-filter: blur(15px) !important;
        }
        .navbar .logo {
            font-size: 1.4rem !important;
        }
        .navbar .nav-link {
            font-size: 0.9rem !important;
            padding: 0.4rem 0.8rem !important;
        }
        .sidebar {
            width: var(--sidebar-width);
            background: rgba(15, 15, 25, 0.85);
            backdrop-filter: blur(25px);
            border-right: 1px solid var(--border-color);
            transition: var(--transition);
            z-index: 1000;
            height: calc(100vh - 70px);
            position: sticky;
            top: 70px;
            overflow-y: auto;
        }

        .sidebar::-webkit-scrollbar {
            width: 4px;
        }
        .sidebar::-webkit-scrollbar-thumb {
            background: var(--primary-gradient);
            border-radius: 10px;
        }

        .app-content {
            padding: 15px 0 !important;
        }
        @media (max-width: 991px) {
            .sidebar {
                position: fixed;
                left: -280px;
                top: 0;
                height: 100vh;
                padding-top: 20px;
                z-index: 1050;
            }
            .sidebar.show {
                left: 0;
                box-shadow: 20px 0 50px rgba(0, 0, 0, 0.5);
            }
            .navbar {
                margin-bottom: 10px !important;
            }
        }

        /* Desktop Collapse State */
        @media (min-width: 992px) {
            #main-wrapper.sidebar-collapsed .sidebar {
                width: 85px;
            }
            #main-wrapper.sidebar-collapsed .sidebar span,
            #main-wrapper.sidebar-collapsed .sidebar-header {
                display: none;
            }
            #main-wrapper.sidebar-collapsed .sidebar .nav-link {
                justify-content: center;
                padding: 15px 0;
                margin: 5px 10px;
            }
            #main-wrapper.sidebar-collapsed .sidebar .nav-link i {
                margin: 0;
                font-size: 1.3rem;
            }
        }
        <?php } ?>

        .app-content {
            flex: 1;
            padding: 40px 0;
            position: relative;
            z-index: 1;
            min-width: 0; /* Prevent horizontal scroll */
        }

        .dashboard-card {
            background: var(--card-bg);
            backdrop-filter: blur(20px);
            border: 1px solid var(--border-color);
            border-radius: 20px;
            padding: 30px;
            height: 100%;
            transition: var(--transition);
        }

        .dashboard-card:hover {
            transform: translateY(-8px);
            border-color: var(--primary);
            box-shadow: var(--shadow-large);
        }

        .alert-custom {
            background: rgba(240, 5, 193, 0.1);
            border: 1px solid var(--border-color);
            color: #fff;
            border-radius: 15px;
            padding: 15px 25px;
            margin-bottom: 25px;
            display: flex;
            align-items: center;
            gap: 15px;
            backdrop-filter: blur(10px);
        }

        .nav-sidebar .nav-link {
            display: flex;
            align-items: center;
            color: var(--text-secondary);
            padding: 14px 25px;
            border-radius: 12px;
            margin: 6px 15px;
            font-weight: 500;
            transition: var(--transition);
            gap: 12px;
        }

        .nav-sidebar .nav-link i {
            font-size: 1.15rem;
            width: 24px;
            text-align: center;
        }

        .nav-sidebar .nav-link:hover, .nav-sidebar .nav-link.active {
            color: #fff;
            background: var(--primary-gradient);
            box-shadow: var(--shadow-primary);
            transform: scale(1.05);
        }
        
        .sidebar-header {
            padding: 25px 30px 10px;
            font-size: 0.75rem;
            text-transform: uppercase;
            letter-spacing: 2px;
            color: var(--text-muted);
            font-weight: 800;
            opacity: 0.8;
        }

        /* Legacy Compatibility Styles */
        .card-sm, .card-md, .card-lg, .dashboard-card, .feature-card {
            background: var(--card-bg) !important;
            backdrop-filter: blur(15px) !important;
            border: 1px solid var(--border-color) !important;
            border-radius: 20px !important;
            padding: 1.5rem !important;
            transition: var(--transition) !important;
            color: var(--text-primary) !important;
            margin-bottom: 1.5rem;
        }
        .card-sm:hover, .dashboard-card:hover {
            transform: translateY(-5px);
            box-shadow: var(--shadow-primary);
            border-color: rgba(240, 5, 193, 0.5) !important;
        }
        .card-sm .icon, .feature-icon {
            width: 50px;
            height: 50px;
            background: rgba(240, 5, 193, 0.1);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 1rem;
            color: var(--primary-light);
            font-size: 1.25rem;
        }
        .card-sm .card-sm-text h2, .card-sm .card-sm-text h5 {
            color: #fff !important;
            font-weight: 700 !important;
            margin-bottom: 5px !important;
        }
        .card-sm .card-sm-text p {
            color: var(--text-muted) !important;
            font-size: 0.85rem !important;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin: 0 !important;
        }
        .btn-one, .btn-primary-custom {
            background: var(--primary-gradient) !important;
            border: none !important;
            color: white !important;
            padding: 12px 25px !important;
            border-radius: 50px !important;
            font-weight: 600 !important;
            transition: var(--transition) !important;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            text-decoration: none !important;
        }
        .btn-one:hover, .btn-primary-custom:hover {
            transform: translateY(-3px);
            box-shadow: var(--shadow-primary);
            filter: brightness(1.1);
        }
        .btn-one:disabled {
            background: #333 !important;
            opacity: 0.6;
            cursor: not-allowed;
        }
        .alert-custom, .alert-warning, .alert-danger, .alert-success {
            border-radius: 15px !important;
            border: 1px solid rgba(255,255,255,0.1) !important;
            backdrop-filter: blur(10px);
            padding: 1rem 1.5rem !important;
        }
    </style>
</head>

<body>
    <!-- Animated Background Shapes -->
    <div class="bg-shapes">
        <div class="shape shape-1"></div>
        <div class="shape shape-2"></div>
        <div class="shape shape-3"></div>
    </div>

    <!-- Floating Particles -->
    <div id="particles-container"></div>

    <div id="main-wrapper">
        <!-- Navigation -->
        <?php if (!in_array($this->uri->segment(1), ['login', 'register', 'forgot-password'])) { ?>
        <nav class="navbar navbar-expand-lg">
            <div class="container-fluid px-lg-5">
                <?php if($this->session->has_userdata('VUID')) { ?>
                    <!-- Dashboard Navbar Layout -->
                    <div class="d-flex align-items-center gap-3">
                        <button class="btn btn-link text-white p-0 me-2" id="sidebar-toggle">
                            <i class="fas fa-bars fa-lg"></i>
                        </button>
                        <a class="logo" href="<?= site_url() ?>"><?= $settings['name'] ?></a>
                    </div>

                    <div class="d-flex align-items-center gap-3">
                        <!-- Notifications -->
                        <div class="dropdown">
                            <a class="text-white-50 position-relative hover-lift" href="#" role="button" data-bs-toggle="dropdown">
                                <i class="fas fa-bell fa-lg"></i>
                                <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger border border-light" style="font-size: 0.6rem; padding: 0.25em 0.4em;">
                                    3
                                </span>
                            </a>
                            <ul class="dropdown-menu dropdown-menu-end p-3" style="min-width: 300px; background: rgba(20, 20, 30, 0.95); border: 1px solid var(--border-color); backdrop-filter: blur(15px);">
                                <h6 class="text-white mb-3">Notifications</h6>
                                <li class="mb-2 pb-2 border-bottom border-secondary opacity-75">
                                    <a href="#" class="text-white text-decoration-none small d-block">Welcome to our new premium platform!</a>
                                </li>
                                <li class="mb-2 pb-2 border-bottom border-secondary opacity-75">
                                    <a href="#" class="text-white text-decoration-none small d-block">Congrats! You've reached Level <?= $user['level'] ?></a>
                                </li>
                                <li>
                                    <a href="#" class="text-white text-decoration-none small d-block">Check out our new Telegram hub for extra rewards.</a>
                                </li>
                            </ul>
                        </div>

                        <!-- Profile Dropdown -->
                        <div class="dropdown ms-2">
                            <a class="nav-link dropdown-toggle d-flex align-items-center gap-2 p-1" href="#" id="profileDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                <div class="rounded-circle d-flex align-items-center justify-content-center overflow-hidden" style="width: 32px; height: 32px; background: var(--primary-gradient);">
                                    <i class="fas fa-user text-white" style="font-size: 0.9rem;"></i>
                                </div>
                                <span class="d-none d-md-inline text-white small fw-bold"><?= $user['username'] ?></span>
                            </a>
                            <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="profileDropdown" style="background: rgba(20, 20, 30, 0.95); border: 1px solid var(--border-color); backdrop-filter: blur(15px);">
                                <li><a class="dropdown-item text-white" href="<?= site_url('account') ?>"><i class="fas fa-user-cog me-2"></i> Settings</a></li>
                                <li><a class="dropdown-item text-white" href="<?= site_url('history') ?>"><i class="fas fa-history me-2"></i> History</a></li>
                                <li><hr class="dropdown-divider" style="background-color: var(--border-color);"></li>
                                <li><a class="dropdown-item text-danger" href="<?= site_url('auth/logout') ?>"><i class="fas fa-sign-out-alt me-2"></i> Logout</a></li>
                            </ul>
                        </div>
                    </div>
                <?php } else { ?>
                    <!-- Guest Navbar Layout -->
                    <a class="logo" href="<?= site_url() ?>"><?= $settings['name'] ?></a>

                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                        <i class="fas fa-bars text-white"></i>
                    </button>

                    <div class="collapse navbar-collapse" id="navbarNav">
                        <ul class="navbar-nav ms-auto align-items-center">
                            <li class="nav-item">
                                <a class="nav-link <?= (!$this->uri->segment(1) || $this->uri->segment(1) == 'home') ? 'active' : '' ?>" href="<?= site_url() ?>">Home</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="<?= site_url() ?>#earn">Earn</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="<?= site_url() ?>#methods">Methods</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="<?= site_url('login') ?>">Login</a>
                            </li>
                            <li class="nav-item ms-lg-2">
                                <a href="<?= site_url('register') ?>" class="btn-primary-custom">Sign Up</a>
                            </li>
                        </ul>
                    </div>
                <?php } ?>
            </div>
        </nav>
        <?php } ?>

        <div id="content-wrapper">
            <?php if($this->session->has_userdata('VUID')) { ?>
                <!-- Sidebar Menu for Dashboard -->
                <aside class="sidebar d-none d-lg-block">
                    <div class="sidebar-header">Main Menu</div>
                    <nav class="nav-sidebar">
                        <a href="<?= site_url('dashboard') ?>" class="nav-link <?= $this->uri->segment(1) == 'dashboard' ? 'active' : '' ?>">
                            <i class="fas fa-grid-2"></i> <span>Console</span>
                        </a>
                        <a href="<?= site_url('daily_streak') ?>" class="nav-link <?= $this->uri->segment(1) == 'daily_streak' ? 'active' : '' ?>">
                            <i class="fas fa-calendar-star"></i> <span>Daily Streak</span>
                        </a>
                        <a href="<?= site_url('faucet') ?>" class="nav-link <?= $this->uri->segment(1) == 'faucet' ? 'active' : '' ?>">
                            <i class="fas fa-faucet-drip"></i> <span>Main Faucet</span>
                        </a>
                        <a href="<?= site_url('ptc') ?>" class="nav-link <?= $this->uri->segment(1) == 'ptc' ? 'active' : '' ?>">
                            <i class="fas fa-eye"></i> <span>PTC Rewards</span>
                        </a>
                        <a href="<?= site_url('links') ?>" class="nav-link <?= $this->uri->segment(1) == 'links' ? 'active' : '' ?>">
                            <i class="fas fa-link-horizontal"></i> <span>Shortlinks</span>
                        </a>
                    </nav>

                    <div class="sidebar-header">Gaming Zone</div>
                    <nav class="nav-sidebar">
                        <a href="<?= site_url('lottery') ?>" class="nav-link <?= $this->uri->segment(1) == 'lottery' ? 'active' : '' ?>">
                            <i class="fas fa-ticket-alt"></i> <span>Lottery Jackpot</span>
                        </a>
                        <a href="<?= site_url('dice') ?>" class="nav-link <?= $this->uri->segment(1) == 'dice' ? 'active' : '' ?>">
                            <i class="fas fa-dice"></i> <span>Dice Roller</span>
                        </a>
                        <a href="<?= site_url('coinflip') ?>" class="nav-link <?= $this->uri->segment(1) == 'coinflip' ? 'active' : '' ?>">
                            <i class="fas fa-coin"></i> <span>Coin Flip</span>
                        </a>
                        <a href="<?= site_url('wheel') ?>" class="nav-link <?= $this->uri->segment(1) == 'wheel' ? 'active' : '' ?>">
                            <i class="fas fa-spinner"></i> <span>Lucky Wheel</span>
                        </a>
                        <a href="<?= site_url('mining') ?>" class="nav-link <?= $this->uri->segment(1) == 'mining' ? 'active' : '' ?>">
                            <i class="fas fa-microchip"></i> <span>Mining Console</span>
                        </a>
                    </nav>
                    
                    <div class="sidebar-header">Expansion</div>
                    <nav class="nav-sidebar">
                        <a href="<?= site_url('offerwalls') ?>" class="nav-link <?= $this->uri->segment(1) == 'offerwalls' ? 'active' : '' ?>">
                            <i class="fas fa-briefcase"></i> <span>Offerwalls</span>
                        </a>
                        <a href="<?= site_url('tasks') ?>" class="nav-link <?= $this->uri->segment(1) == 'tasks' ? 'active' : '' ?>">
                            <i class="fas fa-clipboard-list-check"></i> <span>Micro Tasks</span>
                        </a>
                        <a href="<?= site_url('achievements') ?>" class="nav-link <?= $this->uri->segment(1) == 'achievements' ? 'active' : '' ?>">
                            <i class="fas fa-shield-check"></i> <span>Achievements</span>
                        </a>
                        <a href="<?= site_url('referrals') ?>" class="nav-link <?= $this->uri->segment(1) == 'referrals' ? 'active' : '' ?>">
                            <i class="fas fa-user-group-crown"></i> <span>Affiliates</span>
                        </a>
                        <a href="<?= site_url('contest') ?>" class="nav-link <?= $this->uri->segment(1) == 'contest' ? 'active' : '' ?>">
                            <i class="fas fa-swords"></i> <span>Global Contest</span>
                        </a>
                    </nav>

                    <div class="sidebar-header">Advertising</div>
                    <nav class="nav-sidebar">
                        <a href="<?= site_url('advertise') ?>" class="nav-link <?= $this->uri->segment(2) == 'create' ? 'active' : '' ?>">
                            <i class="fas fa-plus-circle"></i> <span>Create Ad</span>
                        </a>
                        <a href="<?= site_url('advertise/manage') ?>" class="nav-link <?= $this->uri->segment(2) == 'manage' ? 'active' : '' ?>">
                            <i class="fas fa-chart-line-up"></i> <span>Manage Ads</span>
                        </a>
                    </nav>

                    <div class="sidebar-header">Banking</div>
                    <nav class="nav-sidebar">
                        <a href="<?= site_url('deposit') ?>" class="nav-link <?= $this->uri->segment(1) == 'deposit' ? 'active' : '' ?>">
                            <i class="fas fa-wallet-plus"></i> <span>Add Funds</span>
                        </a>
                        <a href="<?= site_url('withdraw') ?>" class="nav-link <?= $this->uri->segment(1) == 'withdraw' ? 'active' : '' ?>">
                            <i class="fas fa-money-check-edit"></i> <span>Withdraw</span>
                        </a>
                        <a href="<?= site_url('history') ?>" class="nav-link <?= $this->uri->segment(1) == 'history' ? 'active' : '' ?>">
                            <i class="fas fa-receipt"></i> <span>Ledger</span>
                        </a>
                    </nav>
                    <div class="pb-5"></div>
                </aside>
            <?php } ?>

            <!-- Main App Content Container -->
            <main class="app-content w-100 <?= in_array($this->uri->segment(1), ['login', 'register', 'forgot-password']) ? 'pt-5 mt-5' : '' ?>">
                <div class="<?= (!$this->uri->segment(1) || $this->uri->segment(1) == 'home') ? 'container-fluid p-0' : 'container' ?><?= $this->session->has_userdata('VUID') ? '-fluid px-lg-4' : '' ?>">
                    <?php if(!empty($this->session->flashdata('message'))) { ?>
                        <div class="alert alert-custom alert-dismissible fade show mb-4" role="alert">
                            <?= $this->session->flashdata('message') ?>
                            <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php } ?>
                    
                    <div id="app-content">
                        <?= $contents ?>
                    </div>
                </div>
            </main>
        </div>

        <!-- Footer -->
        <footer class="footer mt-5 pt-5 pb-4">
            <div class="container">
                <div class="row g-4">
                    <div class="col-lg-4 text-center text-lg-start">
                        <a href="<?= site_url() ?>" class="footer-logo mb-3"><?= $settings['name'] ?></a>
                        <p class="text-secondary small mb-4">Your premier destination for effortless cryptocurrency earning. Join us to start earning cryptocurrency rewards today!</p>
                        <div class="social-icons justify-content-center justify-content-lg-start">
                            <a href="<?= $settings['telegram_url'] ?>" class="social-icon" target="_blank"><i class="fab fa-telegram"></i></a>
                            <a href="<?= $settings['youtube_url'] ?>" class="social-icon" target="_blank"><i class="fab fa-youtube"></i></a>
                            <a href="#" class="social-icon"><i class="fab fa-twitter"></i></a>
                            <a href="#" class="social-icon"><i class="fab fa-discord"></i></a>
                        </div>
                    </div>
                    <div class="col-lg-2 col-md-4 text-center text-md-start">
                        <h5 class="text-white mb-4 small text-uppercase tracking-wider">Join Us</h5>
                        <div class="footer-links">
                            <a href="<?= site_url('login') ?>" class="d-block mb-2 small text-secondary">Login</a>
                            <a href="<?= site_url('register') ?>" class="d-block mb-2 small text-secondary">Register</a>
                        </div>
                    </div>
                    <div class="col-lg-2 col-md-4 text-center text-md-start">
                        <h5 class="text-white mb-4 small text-uppercase tracking-wider">Legal</h5>
                        <div class="footer-links">
                            <a href="<?= site_url('page/terms') ?>" class="d-block mb-2 small text-secondary">Terms of Service</a>
                            <a href="<?= site_url('page/privacy') ?>" class="d-block mb-2 small text-secondary">Privacy Policy</a>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-4 text-center text-md-start">
                        <h5 class="text-white mb-4 small text-uppercase tracking-wider">Support</h5>
                        <div class="footer-links">
                            <a href="<?= $settings['telegram_url'] ?>" class="d-block mb-2 small text-secondary"><i class="fab fa-telegram me-2"></i>Telegram Channel</a>
                            <a href="mailto:support@<?= $_SERVER['HTTP_HOST'] ?>" class="d-block mb-2 small text-secondary"><i class="fas fa-envelope me-2"></i>Email Support</a>
                        </div>
                    </div>
                </div>
                <hr class="border-secondary opacity-25 mt-5">
                <div class="row mt-4">
                    <div class="col-12 text-center">
                        <p class="text-secondary small mb-0">© <?= date('Y') ?> <span class="text-white fw-bold"><?= $settings['name'] ?></span>. All rights reserved.</p>
                    </div>
                </div>
            </div>
        </footer>
    </div>

    <!-- JavaScript -->
    <script src="<?= base_url('assets/libs/jquery/jquery.min.js') ?>"></script>
    <script src="<?= base_url('theme/libs/bootstrap/js/bootstrap.bundle.min.js') ?>"></script>

    <script>
        // Custom JS from Theme
        function createParticles() {
            const container = document.getElementById('particles-container');
            if(!container) return;
            for (let i = 0; i < 30; i++) {
                const particle = document.createElement('div');
                particle.className = 'particle';
                particle.style.left = Math.random() * 100 + 'vw';
                particle.style.animationDelay = Math.random() * 15 + 's';
                particle.style.width = Math.random() * 6 + 2 + 'px';
                particle.style.height = particle.style.width;
                container.appendChild(particle);
            }
        }

        window.addEventListener('scroll', function() {
            const navbar = document.querySelector('.navbar');
            if (window.scrollY > 50) {
                navbar.classList.add('scrolled');
            } else {
                navbar.classList.remove('scrolled');
            }
        });

        $(document).ready(function() {
            createParticles();
            
            // Sidebar Toggle
            $('#sidebar-toggle').click(function(e) {
                e.preventDefault();
                if ($(window).width() > 991) {
                    $('#main-wrapper').toggleClass('sidebar-collapsed');
                } else {
                    $('.sidebar').toggleClass('show');
                }
            });

            // Close sidebar on mobile when clicking outside
            $(document).mousedown(function(e) {
                var container = $(".sidebar, #sidebar-toggle");
                if (!container.is(e.target) && container.has(e.target).length === 0 && $(window).width() <= 991) {
                    $('.sidebar').removeClass('show');
                }
            });
        });
    </script>
    
    <!-- CodeIgniter dynamic scripts -->
    <?php if (isset($antibot_js)) echo $antibot_js; ?>
</body>

</html>
