<?php if ($settings['tasks_top_ad']) { ?>
    <div class="ads mb-4 text-center">
        <?= $settings['tasks_top_ad'] ?>
    </div>
<?php } ?>

<div class="row g-4 justify-content-center">
    <!-- Notice Bar -->
    <div class="col-12 text-start">
        <div class="alert alert-danger border-0 bg-danger bg-opacity-10 text-danger p-3 rounded-4 mb-2 d-flex align-items-center gap-3">
            <i class="fas fa-user-shield fa-lg text-danger"></i>
            <p class="mb-0 small fw-bold">Fake proofs will lead to <span class="text-white">immediate account suspension</span>. Please provide legitimate verification.</p>
        </div>
    </div>

    <?php if (isset($_SESSION['message'])) echo '<div class="col-12">' . $_SESSION['message'] . '</div>'; ?>

    <div class="col-12">
        <div class="row g-4">
            <!-- Available Tasks -->
            <?php foreach ($availableTasks as $task): ?>
                <div class="col-12">
                    <div class="dashboard-card p-4 p-md-5 text-start hover-lift transition">
                        <div class="row align-items-center">
                            <div class="col-lg-8">
                                <div class="d-flex align-items-center gap-3 mb-3">
                                    <div class="feature-icon small bg-primary bg-opacity-10">
                                        <i class="fas fa-thumbtack text-gradient"></i>
                                    </div>
                                    <h3 class="text-white mb-0"><?= $task['name'] ?></h3>
                                </div>
                                <p class="text-secondary mb-4"><?= $task['description'] ?></p>
                                
                                <div class="d-flex flex-wrap gap-2 mb-4">
                                    <span class="badge rounded-pill bg-warning bg-opacity-10 text-warning border border-warning border-opacity-10 px-3 py-2">
                                        <i class="fas fa-coins me-1"></i> Reward: <?= currencyDisplay($task['usd_reward'], $settings) ?>
                                    </span>
                                    <span class="badge rounded-pill bg-info bg-opacity-10 text-info border border-info border-opacity-10 px-3 py-2">
                                        <i class="fas fa-bolt me-1"></i> Energy: <?= $task['energy_reward'] ?>
                                    </span>
                                    <span class="badge rounded-pill bg-primary bg-opacity-10 text-primary border border-primary border-opacity-10 px-3 py-2">
                                        <i class="fas fa-level-up-alt me-1"></i> EXP: <?= $task['exp_reward'] ?>
                                    </span>
                                </div>
                            </div>
                            
                            <div class="col-lg-4">
                                <form action="<?= site_url('tasks/complete/' . $task['id']) ?>" method="post" autocomplete="off" class="bg-white bg-opacity-5 p-4 rounded-4 border border-white border-opacity-5 shadow-sm">
                                    <input type="hidden" name="<?= $csrf_name ?>" value="<?= $csrf_hash ?>" />
                                    <label class="text-secondary smaller fw-bold mb-2 d-block">Required Proof:</label>
                                    <div class="input-group mb-3">
                                        <span class="input-group-text border-0 bg-white bg-opacity-5 text-secondary px-3"><i class="fas fa-paperclip smaller"></i></span>
                                        <input type="text" name="proof" class="form-control border-0 bg-white bg-opacity-5 text-white p-3 small" 
                                               placeholder="<?= $task['requirement'] ?>" required>
                                    </div>
                                    <button type="submit" class="btn-primary-custom w-100 py-2 rounded-pill">
                                        <i class="fas fa-check-circle me-2"></i> Submit Proof
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>

            <!-- Pending Tasks -->
            <?php foreach ($pendingTasks as $task): ?>
                <div class="col-12 opacity-75">
                    <div class="dashboard-card p-4 p-md-5 text-start bg-white bg-opacity-5 border-white border-opacity-5">
                        <div class="row align-items-center">
                            <div class="col-lg-8">
                                <div class="d-flex align-items-center gap-3 mb-3">
                                    <div class="feature-icon small bg-secondary bg-opacity-10">
                                        <i class="fas fa-hourglass-half text-secondary"></i>
                                    </div>
                                    <h3 class="text-white mb-0 opacity-50"><?= $task['name'] ?></h3>
                                    <span class="badge bg-info bg-opacity-10 text-info px-3 py-1 rounded-pill small">Under Review</span>
                                </div>
                                <p class="text-secondary mb-4 opacity-50"><?= $task['description'] ?></p>
                                
                                <div class="d-flex flex-wrap gap-2 mb-4 opacity-50">
                                    <span class="badge rounded-pill bg-white bg-opacity-10 text-secondary border border-white border-opacity-5 px-3 py-2">
                                        <?= currencyDisplay($task['usd_reward'], $settings) ?>
                                    </span>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="bg-black bg-opacity-20 p-4 rounded-4 border border-white border-opacity-5 text-center">
                                    <p class="text-secondary smaller mb-2">Your submitted proof:</p>
                                    <p class="text-white small fw-bold mb-0 italic">"<?= $task['proof'] ?>"</p>
                                    <button class="btn btn-dark w-100 mt-3 rounded-pill opacity-50" disabled>Pending Approval</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>

            <?php if (empty($availableTasks) && empty($pendingTasks)): ?>
                <div class="col-12 py-5 text-center">
                    <div class="dashboard-card py-5">
                        <i class="fas fa-tasks fa-4x text-muted mb-4"></i>
                        <h3 class="text-white">No active tasks</h3>
                        <p class="text-secondary">You've completed all available tasks! Check back soon for new opportunities.</p>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<style>
    .smaller { font-size: 0.75rem; }
    .italic { font-style: italic; }
    .input-group-text i { font-size: 0.8rem; }
</style>