<div class="row text-start mb-4">
    <div class="col-12">
        <h2 class="text-white mb-1">Available Surveys</h2>
        <p class="text-secondary small">Participate in research surveys and earn high rewards instantly.</p>
    </div>
</div>

<div class="row g-4">
    <?php
    $surveys = [
        ['status' => $settings['cpx_status'], 'id' => 'cpx', 'name' => 'CPX Research', 'tags' => ['Surveys', 'Mobile', 'High Paying']],
        ['status' => $settings['adgate_status'], 'id' => 'adgate', 'name' => 'AdGate Media', 'tags' => ['Surveys', 'Offers', 'Games']],
        ['status' => $settings['bitlabs_status'], 'id' => 'bitlabs', 'name' => 'BitLabs', 'tags' => ['Surveys', 'Global', 'Fast Reward']]
    ];

    foreach ($surveys as $survey): 
        if (($survey['status'] ?? 'off') !== 'on') continue;
        $img = $survey['id'] . '.' . ($survey['id'] == 'bitlabs' ? 'png' : 'svg');
    ?>
        <div class="col-md-6 col-xl-4">
            <div class="dashboard-card h-100 p-4 d-flex flex-column justify-content-between hover-lift transition">
                <div class="text-center">
                    <div class="offerwall-logo-container mb-4 mx-auto p-3 bg-white bg-opacity-5 rounded-4 d-flex align-items-center justify-content-center" style="height: 100px;">
                        <img src="<?= base_url() ?>assets/coinzi/dash/img/<?= $img ?>" class="img-fluid" style="max-height: 50px;" alt="<?= $survey['name'] ?>">
                    </div>
                    
                    <h5 class="text-white mb-2"><?= $survey['name'] ?></h5>
                    
                    <div class="d-flex flex-wrap justify-content-center gap-2 mb-4">
                        <?php foreach ($survey['tags'] as $tag): ?>
                            <span class="badge rounded-pill bg-info bg-opacity-10 text-info small px-2 py-1"><?= $tag ?></span>
                        <?php endforeach; ?>
                    </div>

                    <div class="star-rating mb-4 text-warning opacity-75 small">
                        <?php for($i=0; $i<5; $i++): ?><i class="fas fa-star me-1"></i><?php endfor; ?>
                    </div>
                </div>

                <a href="<?= site_url('offerwall/' . $survey['id']) ?>" class="btn-primary-custom w-100 py-2">
                    Start Surveys
                </a>
            </div>
        </div>
    <?php endforeach; ?>

    <?php if ($settings['cpx_status'] != 'on' && $settings['adgate_status'] != 'on' && $settings['bitlabs_status'] != 'on'): ?>
        <div class="col-12 py-5 text-center">
            <div class="dashboard-card py-5">
                <i class="fas fa-clipboard-list fa-4x text-muted mb-4"></i>
                <h3 class="text-white">No active surveys</h3>
                <p class="text-secondary">All survey providers are currently offline. Please check back later.</p>
            </div>
        </div>
    <?php endif; ?>
</div>

<style>
    .offerwall-logo-container img {
        transition: var(--transition);
        filter: brightness(1.1);
    }
    .hover-lift:hover .offerwall-logo-container img {
        transform: scale(1.1);
    }
</style>