<?php if ($settings['dashboard_top_ad']) { ?>
    <div class="ads mb-4 text-center">
        <?= $settings['dashboard_top_ad'] ?>
    </div>
<?php } ?>

<div class="row g-4">
    <!-- Referral Header Card -->
    <div class="col-lg-12">
        <div class="dashboard-card p-4 p-md-5" style="background: linear-gradient(135deg, rgba(240, 5, 193, 0.1), rgba(157, 78, 221, 0.1)); border: 1px solid var(--border-color);">
            <div class="row align-items-center">
                <div class="col-lg-8">
                    <div class="d-flex align-items-center gap-3 mb-3">
                        <div class="feature-icon small bg-primary bg-opacity-20 border border-primary border-opacity-25">
                            <i class="fas fa-users text-gradient"></i>
                        </div>
                        <div>
                            <h2 class="text-white mb-0">Refer & Earn Rewards</h2>
                            <p class="text-white-50 small mb-0">Invite your friends and earn <span class="text-white fw-bold"><?= $settings['referral'] ?>%</span> lifetime commission on their earnings!</p>
                        </div>
                    </div>

                    <div class="mt-4">
                        <label class="text-secondary small text-uppercase tracking-wider mb-2 d-block">Your Unique Referral Link</label>
                        <div class="input-group">
                            <input type="text" id="refer-link" class="form-control border-0 bg-white bg-opacity-10 text-white p-3 rounded-start-4" 
                                   readonly value="<?= site_url('/?r=' . $user['id']) ?>">
                            <button class="btn-primary-custom px-4 rounded-end-4" type="button" id="copy-btn">
                                <i class="fas fa-copy me-2"></i> Copy Link
                            </button>
                        </div>
                        <div id="copy-status" class="text-success small mt-2 fw-bold" style="display: none;">
                            <i class="fas fa-check-circle me-1"></i> Link copied to clipboard!
                        </div>
                    </div>
                </div>

                <div class="col-lg-4 text-center mt-4 mt-lg-0 border-start border-white border-opacity-10">
                    <div class="p-3">
                        <span class="text-secondary small text-uppercase tracking-wider mb-1 d-block">Commission Rate</span>
                        <h1 class="display-3 fw-bold text-gradient mb-0"><?= $settings['referral'] ?>%</h1>
                        <span class="text-white small fw-bold">Passive Daily Earnings</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Referrals Table -->
    <div class="col-lg-12">
        <div class="dashboard-card p-4">
            <h4 class="text-white text-start mb-4"><i class="fas fa-list text-secondary me-2"></i> Your Recent Referrals</h4>
            <div class="table-responsive">
                <table class="table table-dark table-hover border-white border-opacity-5 mb-0">
                    <thead>
                        <tr class="text-secondary small text-uppercase tracking-tighter">
                            <th class="border-0 bg-white bg-opacity-5">Username</th>
                            <th class="border-0 bg-white bg-opacity-5">Last Activity</th>
                            <th class="border-0 bg-white bg-opacity-5 text-end">Total Commission</th>
                        </tr>
                    </thead>
                    <tbody class="text-white border-0">
                        <?php if (empty($referrals)): ?>
                            <tr>
                                <td colspan="3" class="text-center py-5 text-secondary border-0 italic">You don't have any referrals yet. Start sharing your link to earn!</td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($referrals as $referral): ?>
                                <tr class="transition">
                                    <td class="border-0 py-3 d-flex align-items-center gap-3">
                                        <div class="rounded-circle bg-white bg-opacity-5 d-flex align-items-center justify-content-center" style="width: 32px; height: 32px;">
                                            <i class="fas fa-user-circle text-secondary"></i>
                                        </div>
                                        <span class="fw-bold"><?= $referral["username"] ?></span>
                                    </td>
                                    <td class="border-0 py-3 text-secondary small">
                                        <?= timespan($referral["last_active"], time(), 1) ?> ago
                                    </td>
                                    <td class="border-0 py-3 text-end fw-bold text-success text-opacity-75">
                                        <?= format_money($referral["total_earned"]) ?> Coinz
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<script>
    document.getElementById('copy-btn')?.addEventListener('click', function() {
        const copyText = document.getElementById("refer-link");
        copyText.select();
        copyText.setSelectionRange(0, 99999);
        navigator.clipboard.writeText(copyText.value);
        
        const status = document.getElementById('copy-status');
        status.style.display = 'block';
        setTimeout(() => {
            status.style.display = 'none';
        }, 3000);
    });
</script>

<style>
    .table-hover tbody tr:hover {
        background: rgba(255, 255, 255, 0.02) !important;
    }
    #refer-link {
        cursor: default;
    }
</style>