<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <title><?= $ads['name'] ?> | <?= $settings['name'] ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="<?= $settings['description'] ?>" name="description" />
    <link rel="shortcut icon" href="<?= base_url() ?>assets/images/favicon.ico">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;600;700&display=swap" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        :root {
            --primary: #9d4edd;
            --primary-rgb: 157, 78, 221;
            --bg-body: #0a0a0f;
            --glass-bg: rgba(255, 255, 255, 0.05);
            --glass-border: rgba(255, 255, 255, 0.1);
        }

        body {
            background-color: var(--bg-body);
            color: #ffffff;
            font-family: 'Outfit', sans-serif;
            margin: 0;
            overflow: hidden;
        }

        .ptc-header {
            height: 70px;
            background: rgba(10, 10, 15, 0.9);
            backdrop-filter: blur(20px);
            border-bottom: 1px solid var(--glass-border);
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 30px;
            position: relative;
            z-index: 100;
        }

        .timer-box {
            position: absolute;
            left: 50%;
            transform: translateX(-50%);
            background: rgba(var(--primary-rgb), 0.15);
            border: 1px solid rgba(var(--primary-rgb), 0.3);
            padding: 5px 25px;
            border-radius: 50px;
            display: flex;
            align-items: center;
            gap: 10px;
            box-shadow: 0 0 20px rgba(var(--primary-rgb), 0.2);
        }

        #ptcCountdown {
            font-weight: 700;
            font-size: 1.1rem;
            color: #ffffff;
            font-family: 'JetBrains Mono', monospace;
        }

        .btn-back {
            color: rgba(255,255,255,0.6);
            text-decoration: none;
            font-weight: 600;
            font-size: 0.9rem;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        .btn-back:hover { color: #ffffff; }

        .modal-content {
            background: rgba(20, 20, 30, 0.95);
            backdrop-filter: blur(20px);
            border: 1px solid var(--glass-border);
            border-radius: 2rem;
        }

        .btn-primary-custom {
            background: linear-gradient(135deg, var(--primary), #7b2cbf);
            border: none;
            color: white;
            padding: 12px 30px;
            border-radius: 50px;
            font-weight: 600;
            transition: all 0.3s ease;
            box-shadow: 0 10px 20px rgba(var(--primary-rgb), 0.3);
        }

        iframe#ads {
            width: 100%;
            height: calc(100vh - 70px);
            border: none;
        }
    </style>
</head>
<body>

    <div class="ptc-header shadow-sm">
        <a href="<?= base_url() ?>" class="btn-back">
            <i class="fas fa-arrow-left"></i>
            <span>Exit Ad</span>
        </a>

        <div class="timer-box">
            <i class="fas fa-clock text-primary"></i>
            <span id="ptcCountdown">Initializing...</span>
        </div>

        <div>
            <img src="<?= base_url() ?>assets/images/logo.png" alt="Logo" height="30" class="opacity-75">
        </div>
    </div>

    <iframe id="ads" src="<?= $ads['url'] ?>" sandbox="allow-same-origin allow-scripts allow-forms"></iframe>

    <!-- Captcha Modal -->
    <div class="modal fade" id="ptcCaptcha" tabindex="-1" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content p-4 text-center">
                <div class="modal-header border-0 pb-0 justify-content-center">
                    <h5 class="modal-title fw-bold text-white"><i class="fas fa-check-circle text-primary me-2"></i> Claim Your Reward</h5>
                </div>
                <div class="modal-body py-4">
                    <p class="text-secondary small mb-4">Complete the verification below to credit your balance.</p>
                    
                    <form action="<?= site_url('/ptc/verify/' . $ads['id']) ?>" method="POST">
                        <div class="captcha-render mb-4 p-3 bg-white bg-opacity-5 rounded-4 border border-white border-opacity-5">
                            <?= $captcha_display ?>
                        </div>
                        <input type="hidden" name="<?= $csrf_name ?>" value="<?= $csrf_hash ?>">
                        <button id="verify" class="btn-primary-custom w-100 py-3" type="submit">
                            Confirm & Earn
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        var timer = <?= $ads['timer'] ?>;
        var url = '<?= $ads['url'] ?>';
    </script>
    <script src="<?= base_url() ?>assets/libs/jquery/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Load required PTC and Captcha logic -->
    <script src="<?= base_url() ?>assets/js/vie/captcha.js"></script>
    <script src="<?= base_url() ?>assets/js/vie/ptc.js"></script>
    
    <?php if (isset($_COOKIE['captcha'])) { ?>
        <script>
            $('option[value=<?= $_COOKIE['captcha'] ?>]').attr('selected', 'selected');
        </script>
    <?php } ?>
    
    <?= $settings['footer_code'] ?>
    <?php include 'adblock.php'; ?>
</body>
</html>