<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <title>Payment Proofs | <?= $settings['name'] ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="<?= $settings['description'] ?>" name="description" />
    <link rel="shortcut icon" href="<?= base_url() ?>assets/images/favicon.ico">

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;600;700&display=swap" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        :root {
            --primary: #9d4edd;
            --primary-rgb: 157, 78, 221;
            --bg-body: #0a0a0f;
            --glass-bg: rgba(255, 255, 255, 0.03);
            --glass-border: rgba(255, 255, 255, 0.08);
            --text-main: #ffffff;
            --text-secondary: rgba(255, 255, 255, 0.6);
        }

        body {
            background-color: var(--bg-body);
            background: radial-gradient(circle at top right, rgba(var(--primary-rgb), 0.15) 0%, transparent 40%),
                        radial-gradient(circle at bottom left, rgba(58, 134, 255, 0.1) 0%, transparent 40%),
                        var(--bg-body);
            color: var(--text-main);
            font-family: 'Outfit', sans-serif;
            min-height: 100vh;
            margin: 0;
            padding-top: 100px;
        }

        .navbar {
            background: rgba(10, 10, 15, 0.8) !important;
            backdrop-filter: blur(20px);
            border-bottom: 1px solid var(--glass-border);
            padding: 15px 0;
        }

        .hero-mini {
            padding: 60px 0;
            text-align: center;
        }

        .content-card {
            background: var(--glass-bg);
            backdrop-filter: blur(20px);
            border: 1px solid var(--glass-border);
            border-radius: 2rem;
            padding: 2.5rem;
            margin-bottom: 80px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.3);
        }

        .text-gradient {
            background: linear-gradient(to right, #ffffff, var(--primary));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .table-dark {
            background: transparent !important;
        }
        .table-dark thead th {
            background: rgba(255, 255, 255, 0.05);
            border-bottom: 1px solid var(--glass-border);
            color: var(--text-secondary);
            font-size: 0.75rem;
            text-transform: uppercase;
            letter-spacing: 1px;
            padding: 15px;
        }
        .table-dark tbody td {
            border-bottom: 1px solid var(--glass-border);
            padding: 15px;
            vertical-align: middle;
        }

        .btn-primary-custom {
            background: linear-gradient(135deg, var(--primary), #7b2cbf);
            border: none;
            color: white;
            padding: 12px 30px;
            border-radius: 50px;
            font-weight: 600;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-block;
        }

        footer {
            border-top: 1px solid var(--glass-border);
            padding: 40px 0;
            margin-top: auto;
            color: var(--text-secondary);
        }
        footer a { color: var(--primary); text-decoration: none; }
    </style>
</head>
<body>

    <nav class="navbar navbar-expand-lg fixed-top">
        <div class="container">
            <a class="navbar-brand" href="<?= base_url() ?>">
                <img src="<?= base_url() ?>assets/images/logo.png" alt="Logo" height="40">
            </a>
            <div class="ms-auto">
                <a href="<?= site_url() ?>" class="btn-primary-custom py-2 px-4 shadow-sm">
                    <i class="fas fa-home me-2"></i> Back Home
                </a>
            </div>
        </div>
    </nav>

    <div class="container">
        <div class="hero-mini">
            <div class="feature-icon mx-auto mb-3" style="width: 60px; height: 60px; background: rgba(var(--primary-rgb), 0.1); border-radius: 50%; display: flex; align-items: center; justify-content: center;">
                <i class="fas fa-shield-check text-primary fa-lg"></i>
            </div>
            <h1 class="display-4 fw-bold text-gradient mb-3">Recent Payouts</h1>
            <p class="text-secondary">We believe in complete transparency. Here are our latest user withdrawals.</p>
        </div>

        <div class="row justify-content-center">
            <div class="col-lg-12">
                <div class="content-card">
                    <div class="table-responsive">
                        <table class="table table-dark table-hover text-center mb-0">
                            <thead>
                                <tr>
                                    <th class="text-start"># ID</th>
                                    <th>Amount</th>
                                    <th>Method / Address</th>
                                    <th class="text-end">Time</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (empty($proofs)): ?>
                                    <tr><td colspan="4" class="py-5 text-secondary italic">No payouts recorded yet.</td></tr>
                                <?php else: ?>
                                    <?php foreach ($proofs as $value): ?>
                                        <tr class="transition">
                                            <td class="text-start font-monospace small opacity-50">#<?= $value["id"] ?></td>
                                            <td class="fw-bold text-success"><?= $value["amount"] ?> Coinz</td>
                                            <td>
                                                <span class="badge bg-white bg-opacity-5 text-secondary border border-white border-opacity-10 px-3 py-2 rounded-pill font-monospace small">
                                                    <?= substr($value["wallet"], 0, 10) ?>...<?= substr($value["wallet"], -10) ?>
                                                </span>
                                            </td>
                                            <td class="text-end text-secondary small"><?= timespan($value["claim_time"], time(), 2) ?> ago</td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <footer>
        <div class="container text-center">
            <div class="row">
                <div class="col-md-6 text-md-start mb-3 mb-md-0">
                    <p class="mb-0">&copy; <?= date('Y') ?> <strong><?= $settings['name'] ?></strong>. All rights reserved.</p>
                </div>
                <div class="col-md-6 text-md-end">
                    <p class="mb-0">Powered by <a href="#">Vie Faucet Script</a></p>
                </div>
            </div>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>