<div class="row g-4 justify-content-center">
    <div class="col-lg-12">
        <div class="dashboard-card p-4 p-md-5">
            <div class="d-flex align-items-center gap-3 mb-4">
                <div class="feature-icon small bg-primary bg-opacity-10">
                    <i class="fas fa-hand-holding-usd text-gradient"></i>
                </div>
                <div>
                    <h2 class="text-white mb-0">Payout Request</h2>
                    <p class="text-secondary small mb-0">Send your accumulated rewards directly to your crypto wallet.</p>
                </div>
            </div>

            <?php if (isset($_SESSION['message'])) echo $_SESSION['message']; ?>
            <?php if (isset($_SESSION['withdraw_message'])) echo $_SESSION['withdraw_message']; ?>

            <form action="<?= site_url('payout/withdraw') ?>" method="POST" autocomplete="off" id="payout-withdraw-form">
                <input type="hidden" name="<?= $csrf_name ?>" value="<?= $csrf_hash ?>">

                <!-- Method Selection -->
                <div class="mb-5">
                    <label class="text-white small text-uppercase tracking-wider fw-bold mb-3 d-block">1. Select Payout Method</label>
                    <div class="row g-4">
                        <script>
                            var currencies = [];
                            var rate = <?= $settings['currency_rate'] ?>;
                        </script>
                        <?php foreach ($methods as $method): ?>
                            <div class="col-xl-4 col-md-6">
                                <label class="currency-selector-card w-100 h-100">
                                    <input type="radio" name="method" value="<?= $method['id'] ?>" class="d-none" required>
                                    <div class="selector-content p-4 rounded-4 border border-white border-opacity-10 bg-white bg-opacity-5 h-100 transition shadow-sm text-center">
                                        <div class="currency-logo-wrapper mx-auto rounded-circle p-2 bg-white bg-opacity-10 mb-3" style="width: 80px; height: 80px; display: flex; align-items: center; justify-content: center;">
                                            <img src="<?= site_url('assets/images/currencies/' . strtolower($method['currency_name']) . '.png') ?>" class="img-fluid" alt="<?= $method['currency_name'] ?>" style="max-height: 50px;">
                                        </div>
                                        
                                        <h5 class="text-white mb-1"><?= $method['name'] ?></h5>
                                        <div class="badge bg-primary bg-opacity-10 text-primary mb-3 px-3 py-2 rounded-pill">
                                            Min: <?= rtrim(rtrim(number_format($method['minimum_withdrawal'], 8), '0'), '.') ?> <?= $method['code'] ?>
                                        </div>
                                        
                                        <p class="text-secondary smaller mb-0">Reward: <span class="text-white fw-bold"><?= currencyDisplay($method['cost'], $settings) ?></span></p>
                                    </div>
                                    <script>
                                        currencies['<?= $method['id'] ?>'] = {
                                            price: <?= $method['price'] ?>,
                                            code: '<?= $method['code'] ?>',
                                            minimumWithdrawal: <?= $method['minimum_withdrawal'] ?>
                                        };
                                    </script>
                                </label>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>

                <div class="row g-4">
                    <!-- Wallet Column -->
                    <div class="col-12">
                        <label class="text-white small text-uppercase tracking-wider fw-bold mb-3 d-block">2. Withdrawal Destination</label>
                        <div class="input-group">
                            <span class="input-group-text border-0 bg-white bg-opacity-5 text-secondary px-3">
                                <i class="fas fa-wallet"></i>
                            </span>
                            <input class="form-control border-0 bg-white bg-opacity-5 text-white p-3" 
                                   placeholder="Enter Your Payment Email (NOT COIN ADDRESS)" type="text" name="wallet" value="<?= $user['wallet'] ?>" required>
                        </div>
                        <p class="text-info smaller mt-2"><i class="fas fa-info-circle me-1"></i> Ensure you use your FaucetPay or Coinbase email address.</p>
                    </div>

                    <!-- Captcha & Submit -->
                    <div class="col-12 mt-4 text-center">
                        <div class="captcha-wrapper mx-auto mb-4 py-3 bg-white bg-opacity-5 rounded-4 border border-white border-opacity-10 d-inline-block px-4">
                            <?= $captcha_display ?>
                        </div>
                        
                        <div class="w-100">
                             <button type="submit" class="btn-primary-custom px-5 py-3 rounded-pill shadow-lg">
                                <i class="fas fa-check-circle me-2"></i> Confirm Payout
                             </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<style>
    .currency-selector-card input:checked + .selector-content {
        background: var(--primary-gradient) !important;
        border-color: rgba(255,255,255,0.3) !important;
        transform: translateY(-5px);
        box-shadow: 0 10px 30px rgba(157, 78, 221, 0.4);
    }
    .currency-selector-card input:checked + .selector-content .text-white,
    .currency-selector-card input:checked + .selector-content .text-secondary,
    .currency-selector-card input:checked + .selector-content .badge {
        color: white !important;
        background: rgba(255,255,255,0.1) !important;
    }
    .currency-selector-card .selector-content:hover {
        border-color: var(--primary);
        cursor: pointer;
    }
    .currency-logo-wrapper { border: 1px solid rgba(255,255,255,0.05); }
    .smaller { font-size: 0.75rem; }
</style>

<script>
    document.getElementById('payout-withdraw-form')?.addEventListener('submit', function() {
        const btn = this.querySelector('button[type=submit]');
        btn.disabled = true;
        btn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Processing...';
    });
</script>