<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <title><?= $page ?> | <?= $settings['name'] ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="<?= $settings['description'] ?>" name="description" />
    <link rel="shortcut icon" href="<?= base_url() ?>assets/images/favicon.ico">

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;600;700&display=swap" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        :root {
            --primary: #9d4edd;
            --primary-rgb: 157, 78, 221;
            --bg-body: #0a0a0f;
            --glass-bg: rgba(255, 255, 255, 0.03);
            --glass-border: rgba(255, 255, 255, 0.08);
            --text-main: #ffffff;
            --text-secondary: rgba(255, 255, 255, 0.6);
        }

        body {
            background-color: var(--bg-body);
            background: radial-gradient(circle at top right, rgba(var(--primary-rgb), 0.15) 0%, transparent 40%),
                        radial-gradient(circle at bottom left, rgba(58, 134, 255, 0.1) 0%, transparent 40%),
                        var(--bg-body);
            color: var(--text-main);
            font-family: 'Outfit', sans-serif;
            min-height: 100vh;
            margin: 0;
            padding-top: 100px;
        }

        .navbar {
            background: rgba(10, 10, 15, 0.8) !important;
            backdrop-filter: blur(20px);
            border-bottom: 1px solid var(--glass-border);
            padding: 15px 0;
        }

        .nav-link {
            color: var(--text-secondary) !important;
            font-weight: 500;
            transition: all 0.3s ease;
        }

        .nav-link:hover, .nav-link.active {
            color: var(--primary) !important;
        }

        .hero-mini {
            padding: 60px 0;
            text-align: center;
        }

        .content-card {
            background: var(--glass-bg);
            backdrop-filter: blur(20px);
            border: 1px solid var(--glass-border);
            border-radius: 2rem;
            padding: 3rem;
            margin-bottom: 80px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.3);
        }

        .text-gradient {
            background: linear-gradient(to right, #ffffff, var(--primary));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .btn-primary-custom {
            background: linear-gradient(135deg, var(--primary), #7b2cbf);
            border: none;
            color: white;
            padding: 12px 30px;
            border-radius: 50px;
            font-weight: 600;
            transition: all 0.3s ease;
            box-shadow: 0 10px 20px rgba(var(--primary-rgb), 0.3);
        }

        .btn-primary-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 15px 25px rgba(var(--primary-rgb), 0.4);
            color: white;
        }

        footer {
            border-top: 1px solid var(--glass-border);
            padding: 40px 0;
            margin-top: auto;
            color: var(--text-secondary);
        }

        footer a { color: var(--primary); text-decoration: none; }
    </style>
</head>
<body>

    <nav class="navbar navbar-expand-lg fixed-top">
        <div class="container">
            <a class="navbar-brand" href="<?= base_url() ?>">
                <img src="<?= base_url() ?>assets/images/logo.png" alt="Logo" height="40">
            </a>
            <button class="navbar-toggler border-0 text-white" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <i class="fas fa-bars"></i>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto align-items-center">
                    <li class="nav-item"><a class="nav-link px-3" href="<?= site_url() ?>">Home</a></li>
                    <li class="nav-item"><a class="nav-link px-3" href="<?= site_url('register') ?>">Register</a></li>
                    <li class="nav-item ms-lg-3"><a class="btn btn-primary-custom" href="<?= site_url('login') ?>">Login</a></li>
                </ul>
            </div>
        </div>
    </nav>

    <div class="container">
        <div class="hero-mini">
            <h1 class="display-4 fw-bold text-gradient mb-3"><?= $this_page['title'] ?></h1>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb justify-content-center opacity-50">
                    <li class="breadcrumb-item"><a href="<?= base_url() ?>" class="text-white text-decoration-none small">Home</a></li>
                    <li class="breadcrumb-item active text-white small" aria-current="page"><?= $page ?></li>
                </ol>
            </nav>
        </div>

        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="content-card text-light">
                    <div class="page-content">
                        <?= $this_page['content'] ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <footer>
        <div class="container text-center">
            <div class="row">
                <div class="col-md-6 text-md-start mb-3 mb-md-0">
                    <p class="mb-0">&copy; <?= date('Y') ?> <strong><?= $settings['name'] ?></strong>. All rights reserved.</p>
                </div>
                <div class="col-md-6 text-md-end">
                    <p class="mb-0">Powered by <a href="#">Vie Faucet Script</a></p>
                </div>
            </div>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <?php include 'adblock.php'; ?>
</body>
</html>