<div class="row g-4 justify-content-center pt-5">
    <div class="col-lg-8">
        <div class="dashboard-card p-4 p-md-5">
            <div class="d-flex flex-column align-items-center text-center mb-5">
                <div class="feature-icon small bg-primary bg-opacity-10 mb-3" style="width: 80px; height: 80px;">
                    <i class="fas fa-user-edit text-gradient" style="font-size: 2.2rem;"></i>
                </div>
                <h2 class="text-white mb-2 uppercase tracking-widest">Account Migration</h2>
                <p class="text-secondary small">We've upgraded our systems to serve you better! Your data and balance are safe.</p>
            </div>

            <div class="alert alert-info border-0 bg-info bg-opacity-10 text-info p-4 rounded-4 mb-5 text-start d-flex gap-3">
                <div class="mt-1"><i class="fas fa-info-circle fa-lg"></i></div>
                <div>
                    <h5 class="text-white mb-1">Important Update</h5>
                    <p class="mb-0 small">Your balance has been automatically converted to USD. To continue using the faucet, please choose a new unique <strong>username</strong>. <u>Your referrals and earnings remain intact.</u></p>
                </div>
            </div>

            <?php if (isset($_SESSION['message'])) echo '<div class="mb-4 text-start">' . $_SESSION['message'] . '</div>'; ?>

            <form action="<?= site_url('migration/update') ?>" method="POST" class="text-start">
                <input type="hidden" name="<?= $csrf_name ?>" id="token" value="<?= $csrf_hash ?>">

                <div class="mb-5">
                    <label class="text-secondary small text-uppercase fw-bold mb-2 d-block">Choose Your Username</label>
                    <div class="input-group">
                        <span class="input-group-text border-0 bg-white bg-opacity-5 text-secondary px-3"><i class="fas fa-at small"></i></span>
                        <input type="text" name="username" class="form-control border-0 bg-white bg-opacity-5 text-white p-3 font-monospace" 
                               id="username" placeholder="e.g. lucky_user77" 
                               pattern="^[a-zA-Z]{1,1}[a-zA-Z0-9_]{2,13}[a-zA-Z0-9]{1,1}$" required>
                    </div>
                    <div class="mt-2 text-secondary smaller opacity-75">
                        <i class="fas fa-info-circle me-1"></i> 4-15 characters, letters, numbers and underscores only.
                    </div>
                </div>

                <div class="w-100">
                    <button type="submit" class="btn-primary-custom w-100 py-3 rounded-pill shadow-lg fw-bold">
                        <i class="fas fa-user-check me-2"></i> Update Username & Proceed
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<style>
    .font-monospace { font-family: 'JetBrains Mono', monospace !important; }
    .smaller { font-size: 0.75rem; }
</style>