<?php if ($settings['links_top_ad']) { ?>
    <div class="ads mb-4 text-center">
        <?= $settings['links_top_ad'] ?>
    </div>
<?php } ?>

<div class="row g-4 mb-4">
    <!-- Links Available -->
    <div class="col-md-4">
        <div class="dashboard-card text-center hover-lift">
            <div class="feature-icon mx-auto mb-3">
                <i class="fas fa-link text-gradient"></i>
            </div>
            <h5 class="text-secondary small text-uppercase">Links Available</h5>
            <h3 class="text-white mb-0"><?= $countAvailableLinks ?></h3>
        </div>
    </div>

    <!-- Total Reward -->
    <div class="col-md-4">
        <div class="dashboard-card text-center hover-lift">
            <div class="feature-icon mx-auto mb-3">
                <i class="fas fa-coins text-gradient"></i>
            </div>
            <h5 class="text-secondary small text-uppercase">Total Reward</h5>
            <h3 class="text-white mb-0"><?= currencyDisplay($totalReward, $settings) ?></h3>
        </div>
    </div>

    <!-- Total Energy -->
    <div class="col-md-4">
        <div class="dashboard-card text-center hover-lift">
            <div class="feature-icon mx-auto mb-3">
                <i class="fas fa-bolt text-gradient"></i>
            </div>
            <h5 class="text-secondary small text-uppercase">Total Energy</h5>
            <h3 class="text-white mb-0"><?= $totalEnergy ?></h3>
        </div>
    </div>
</div>

<div class="row g-4">
    <?php foreach ($availableLinks as $link): ?>
        <div class="col-lg-6 col-xl-4">
            <div class="dashboard-card h-100 d-flex flex-column justify-content-between p-4">
                <div>
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h4 class="text-white mb-0"><?= $link['name'] ?></h4>
                        <span class="badge rounded-pill bg-primary bg-opacity-20 text-primary small border border-primary border-opacity-25 px-3 py-2">
                            <?= $link['rmnViews'] ?> / <?= $link['view_per_day'] ?> Left
                        </span>
                    </div>

                    <div class="d-flex gap-3 mb-4 mt-3">
                        <div class="d-flex align-items-center gap-2 px-3 py-2 rounded-4 bg-white bg-opacity-5 border border-white border-opacity-5 flex-fill justify-content-center">
                            <i class="fas fa-coins text-warning small"></i>
                            <span class="text-white fw-bold small"><?= currencyDisplay($link['reward'], $settings) ?></span>
                        </div>
                        <div class="d-flex align-items-center gap-2 px-3 py-2 rounded-4 bg-white bg-opacity-5 border border-white border-opacity-5 flex-fill justify-content-center">
                            <i class="fas fa-bolt text-info small"></i>
                            <span class="text-white fw-bold small"><?= $link['energy'] ?></span>
                        </div>
                    </div>
                </div>

                <?php if ($link['rmnViews'] > 0): ?>
                    <a href="<?= base_url() . 'links/go/' . $link['id'] ?>" target="_blank" class="btn-primary-custom w-100">
                        <i class="fas fa-rocket me-2"></i> Claim Now
                    </a>
                <?php else: ?>
                    <button class="btn-primary-custom w-100" disabled style="opacity: 0.5;">
                        <i class="fas fa-check-double me-2"></i> Completed
                    </button>
                <?php endif; ?>
            </div>
        </div>
    <?php endforeach; ?>

    <?php if (!count($availableLinks)): ?>
        <div class="col-12 mt-5 text-center">
            <div class="dashboard-card py-5">
                <i class="fas fa-smile-beam fa-4x text-muted mb-4"></i>
                <h3 class="text-white">Fantastic Work!</h3>
                <p class="text-secondary">You've cleared all the shortlinks for today. Boost your energy and come back tomorrow for even more rewards.</p>
                <a href="<?= site_url('dashboard') ?>" class="btn-primary-custom px-5 mt-3">Return Home</a>
            </div>
        </div>
    <?php endif; ?>
</div>

<?php if ($settings['links_footer_ad']) { ?>
    <div class="ads mt-5 text-center">
        <?= $settings['links_footer_ad'] ?>
    </div>
<?php } ?>