<!-- Hero Section -->
<section id="hero" class="hero-section py-5 overflow-hidden">
    <div class="container py-5">
        <div class="row align-items-center g-5">
            <div class="col-lg-6 hero-content text-start">
                <div class="badge rounded-pill bg-primary bg-opacity-10 text-primary px-3 py-2 mb-4 animate__animated animate__fadeInDown">
                    <i class="fas fa-sparkles me-1 text-warning"></i> Next-Gen Crypto Earning
                </div>
                <h1 class="hero-title display-3 fw-bold mb-4 animate__animated animate__fadeInLeft">
                    Unlock Your <br>
                    <span class="text-gradient">Financial Future</span>
                </h1>

                <p class="hero-subtitle lead text-secondary mb-5 animate__animated animate__fadeInLeft animate__delay-1s">
                    Earn premium rewards in <span class="text-white fw-bold">PEPE, SHIB, BONK, FLOKI</span> and 10+ other cryptocurrencies with instant dual-wallet support.
                </p>

                <div class="d-flex flex-wrap gap-3 animate__animated animate__fadeInUp animate__delay-2s">
                    <a href="<?= site_url('register') ?>" class="btn-primary-custom px-5 py-3">
                        <i class="fas fa-rocket me-2"></i> Get Started Now
                    </a>
                    <a href="#methods" class="btn-secondary px-5 py-3 bg-white bg-opacity-5 text-white border-white border-opacity-10 rounded-pill hover-lift">
                        <i class="fas fa-play-circle me-2"></i> View Methods
                    </a>
                </div>

                 <!-- Ad Slot -->
                 <div class="mt-5 pt-3 animate__animated animate__fadeIn">
                     <script type="text/javascript">
                         if (typeof aclib !== 'undefined') { aclib.runBanner({ zoneId: '8932454' }); }
                     </script>
                 </div>
            </div>

            <div class="col-lg-6 hero-illustration text-center animate__animated animate__zoomIn">
                <div class="position-relative d-inline-block">
                    <div class="hero-blob position-absolute top-50 start-50 translate-middle" style="width: 400px; height: 400px; background: rgba(var(--primary-rgb), 0.2); filter: blur(80px); border-radius: 50%; z-index: -1;"></div>
                    <img src="https://coinzi.net/assets/coinzi/home/img/hero-img.png" alt="Crypto Rewards" class="img-fluid floating-animation" style="max-height: 500px;">
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Trustpilot Section -->
<section class="trustpilot-bar py-5">
    <div class="container">
        <div class="dashboard-card p-4 p-md-5 border-success border-opacity-10" style="background: linear-gradient(135deg, rgba(25, 135, 84, 0.05), rgba(var(--bg-card-rgb), 1));">
            <div class="row align-items-center g-4">
                <div class="col-lg-5">
                    <div class="d-flex align-items-center gap-4 mb-4 mb-lg-0">
                        <div class="reviews-icon display-4 text-success"><i class="fas fa-star-circle"></i></div>
                        <div>
                            <h3 class="text-white mb-2">Excellent Reputation</h3>
                            <p class="text-secondary small mb-0">Join <?= isset($stat['total_user']) ? number_format($stat['total_user']) : '10,000+' ?> happy earners worldwide who trust our instant payment system.</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-7 d-flex justify-content-lg-end">
                    <div class="d-flex gap-5 flex-wrap">
                        <div class="text-center">
                            <h2 class="text-white fw-bold mb-0">4.8</h2>
                            <div class="text-warning small mb-1">
                                <i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star-half-alt"></i>
                            </div>
                            <p class="text-secondary smaller text-uppercase tracking-widest fw-bold">Rating</p>
                        </div>
                        <div class="text-center">
                            <h2 class="text-white fw-bold mb-0">98%</h2>
                            <div class="progress-bar-small bg-success rounded-pill mt-2" style="height: 4px; width: 60px;"></div>
                            <p class="text-secondary smaller text-uppercase tracking-widest fw-bold mt-2">Satisfaction</p>
                        </div>
                        <div class="text-center">
                            <h2 class="text-white fw-bold mb-0">Inst.</h2>
                            <div class="progress-bar-small bg-info rounded-pill mt-2" style="height: 4px; width: 60px;"></div>
                            <p class="text-secondary smaller text-uppercase tracking-widest fw-bold mt-2">Payouts</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Currencies Marquee -->
<section class="py-5">
    <div class="container container-narrow text-center mb-5">
        <h2 class="text-white mb-3">One Wallet, <span class="text-gradient">Multiple Assets</span></h2>
        <p class="text-secondary small">We support the industry's most popular cryptocurrencies and trending meme-coins.</p>
    </div>
    <div class="currency-marquee overflow-hidden py-4 border-y border-white border-opacity-5">
        <div class="d-flex gap-5 currency-scroll">
            <?php 
            $currencies = ['btc' => 'Bitcoin', 'eth' => 'Ethereum', 'doge' => 'Dogecoin', 'bch' => 'Bitcoin Cash', 'ltc' => 'Litecoin', 'trx' => 'Tron', 'shiba' => 'Shiba Inu', 'pepe' => 'Pepe', 'floki' => 'Floki', 'bonk' => 'Bonk'];
            foreach($currencies as $code => $name): 
            ?>
            <div class="currency-pill d-flex align-items-center gap-3 px-4 py-2 rounded-pill bg-white bg-opacity-5 border border-white border-opacity-5 flex-shrink-0 transition">
                <img src="<?= base_url('assets/images/currencies/'.$code.'.png') ?>" alt="<?= $name ?>" height="24">
                <span class="text-white fw-bold small"><?= $name ?></span>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<!-- Telegram Center -->
<section class="py-5">
    <div class="container">
        <div class="dashboard-card p-4 p-md-5 overflow-hidden position-relative">
            <div class="telegram-gradient position-absolute top-0 end-0 h-100" style="width: 40%; background: linear-gradient(to left, rgba(0, 136, 204, 0.1), transparent); z-index: 0;"></div>
            <div class="row align-items-center position-relative" style="z-index: 1;">
                <div class="col-lg-8">
                    <div class="d-flex align-items-center gap-3 mb-4">
                        <i class="fab fa-telegram fa-3x text-info"></i>
                        <h2 class="text-white mb-0">Join Our Telegram Hub</h2>
                    </div>
                    <h4 class="text-secondary mb-4 lh-base">Access daily airdrops, exclusive promo codes, and fast-track support from our amazing community.</h4>
                    <a href="https://t.me/coinzi_announcements" target="_blank" class="btn btn-info btn-lg px-5 py-3 rounded-pill text-white fw-bold shadow-lg border-0" style="background: #0088cc !important;">
                        Open Telegram Channel <i class="fas fa-external-link-alt ms-2 smaller"></i>
                    </a>
                </div>
                <div class="col-lg-4 text-center d-none d-lg-block">
                    <div class="qr-wrapper p-3 bg-white rounded-4 shadow-lg d-inline-block hover-lift">
                        <img src="https://api.qrserver.com/v1/create-qr-code/?size=180x180&data=https://t.me/coinzi_announcements" alt="QR" width="180">
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Features Grid -->
<section id="features" class="py-5">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="text-white">Why Choose <span class="text-gradient"><?= $settings['name'] ?></span>?</h2>
        </div>
        <div class="row g-4">
            <?php 
            $features = [
                ['icon' => 'mouse-pointer', 'title' => 'PTC Ads', 'desc' => 'Quick and simple earnings by viewing advertisements for just a few seconds.'],
                ['icon' => 'bullseye', 'title' => 'Global Offerwalls', 'desc' => 'High-paying surveys, app installs, and research tasks for maximum profit.'],
                ['icon' => 'faucet', 'title' => 'Recurring Faucet', 'desc' => 'Reliable, instant crypto claims available every few minutes round the clock.'],
                ['icon' => 'user-plus', 'title' => 'Affiliate System', 'desc' => 'Invite friends and earn a massive lifetime commission on all their earnings.'],
                ['icon' => 'bolt', 'title' => 'Auto-Pilot', 'desc' => 'Let our auto-faucet do the hard work while you focus on other things.'],
                ['icon' => 'shield-check', 'title' => 'Secure & Private', 'desc' => 'Encrypted data protection and discrete, secure crypto payouts.'],
            ];
            foreach($features as $f): 
            ?>
            <div class="col-md-6 col-lg-4">
                <div class="dashboard-card p-4 h-100 hover-lift transition">
                    <div class="feature-icon small bg-primary bg-opacity-10 mb-3">
                        <i class="fas fa-<?= $f['icon'] ?> text-gradient"></i>
                    </div>
                    <h5 class="text-white mb-2"><?= $f['title'] ?></h5>
                    <p class="text-secondary smaller mb-0"><?= $f['desc'] ?></p>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<!-- Final CTA -->
<section class="py-5 mb-5">
    <div class="container">
        <div class="dashboard-card p-5 text-center border-primary border-opacity-10" style="background: linear-gradient(135deg, rgba(var(--primary-rgb), 0.1), rgba(var(--bg-card-rgb), 1));">
            <h2 class="text-white display-5 fw-bold mb-4">Start Your Earning Journey</h2>
            <p class="text-secondary lead mb-5">Join our global community and start earning real cryptocurrency today.</p>
            <div class="d-flex flex-wrap justify-content-center gap-3">
                <a href="<?= site_url('register') ?>" class="btn-primary-custom px-5 py-3">Create Free Account</a>
                <a href="<?= site_url('login') ?>" class="btn-secondary px-5 py-3 bg-white bg-opacity-5 text-white border-white border-opacity-10 rounded-pill hover-lift">Member Login</a>
            </div>
        </div>
    </div>
</section>

<style>
    .hero-title { line-height: 1.1; }
    .hero-highlight { color: #ffffff; text-shadow: 0 0 10px rgba(var(--primary-rgb), 0.5); }
    .floating-animation { animation: floating 3s infinite ease-in-out; }
    @keyframes floating {
        0%, 100% { transform: translateY(0); }
        50% { transform: translateY(-20px); }
    }
    .currency-scroll {
        animation: scroll 30s linear infinite;
        width: fit-content;
    }
    @keyframes scroll {
        0% { transform: translateX(0); }
        100% { transform: translateX(calc(-50%)); }
    }
    .currency-marquee:after {
        content: "";
        position: absolute;
        top: 0; right: 0; bottom: 0; left: 0;
        background: linear-gradient(to right, var(--bg-body), transparent 20%, transparent 80%, var(--bg-body));
        pointer-events: none;
    }
    .border-y { border-top: 1px solid; border-bottom: 1px solid; }
</style>
