<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reset Password | <?= $settings['name'] ?></title>
    <link rel="shortcut icon" href="<?= base_url() ?>assets/images/favicon.ico">
    
    <!-- Fonts & Icons -->
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        :root {
            --primary: #9d4edd;
            --primary-rgb: 157, 78, 221;
            --bg-body: #0a0a0f;
            --glass-bg: rgba(255, 255, 255, 0.03);
            --glass-border: rgba(255, 255, 255, 0.08);
        }

        body {
            background-color: var(--bg-body);
            background: radial-gradient(circle at top right, rgba(var(--primary-rgb), 0.15) 0%, transparent 40%),
                        radial-gradient(circle at bottom left, rgba(58, 134, 255, 0.1) 0%, transparent 40%),
                        var(--bg-body);
            color: #ffffff;
            font-family: 'Outfit', sans-serif;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0;
            padding: 20px;
        }

        .auth-card {
            background: var(--glass-bg);
            backdrop-filter: blur(20px);
            border: 1px solid var(--glass-border);
            border-radius: 2.5rem;
            width: 100%;
            max-width: 480px;
            padding: 3.5rem;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.5);
        }

        .form-control {
            background: rgba(255, 255, 255, 0.05) !important;
            border: 1px solid rgba(255, 255, 255, 0.1) !important;
            border-radius: 12px !important;
            color: white !important;
            padding: 14px 20px 14px 45px !important;
            transition: all 0.3s ease;
        }
        .form-control:focus {
            background: rgba(255, 255, 255, 0.08) !important;
            border-color: var(--primary) !important;
            box-shadow: 0 0 0 4px rgba(var(--primary-rgb), 0.1);
        }

        .input-icon {
            position: absolute;
            left: 18px;
            top: 50%;
            transform: translateY(-50%);
            color: rgba(255, 255, 255, 0.4);
            z-index: 10;
        }

        .btn-primary-custom {
            background: linear-gradient(135deg, var(--primary), #7b2cbf);
            border: none;
            color: white;
            padding: 15px;
            border-radius: 12px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 1px;
            transition: all 0.3s ease;
            box-shadow: 0 10px 20px rgba(var(--primary-rgb), 0.3);
        }
        .btn-primary-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 15px 25px rgba(var(--primary-rgb), 0.4);
        }

        .extra-link a { color: var(--primary); text-decoration: none; font-weight: 600; }
        .extra-link a:hover { text-decoration: underline; }
    </style>
</head>
<body>

    <div class="auth-card animate__animated animate__fadeIn">
        <div class="text-center mb-5">
            <a href="<?= base_url() ?>">
                <img src="<?= site_url('assets/images/logo.png') ?>" alt="Logo" height="50" class="mb-4">
            </a>
            <h2 class="fw-bold mb-2">Recover Access</h2>
            <p class="text-secondary small">Enter your email to receive recovery link.</p>
        </div>

        <?php if (isset($_SESSION['message'])) echo '<div class="alert alert-info border-0 bg-info bg-opacity-10 text-info p-3 rounded-4 mb-4 small">' . $_SESSION['message'] . '</div>'; ?>

        <form action="<?= site_url('auth/forgot_password') ?>" method="POST">
            <input type="hidden" name="<?= $csrf_name ?>" value="<?= $csrf_hash ?>">
            
            <div class="form-group mb-4 position-relative">
                <i class="fas fa-envelope-open-text input-icon"></i>
                <input class="form-control" type="email" name="email" placeholder="Registered Email Address" required>
            </div>

            <div class="captcha-container mb-4 d-flex justify-content-center">
                <?= $captcha_display ?>
            </div>

            <button class="btn-primary-custom w-100 mb-4" type="submit">Send Reset Link</button>
        </form>

        <div class="extra-link text-center small text-secondary">
            Remembered your credentials? <a href="<?= site_url('login') ?>">Sign In</a>
        </div>
    </div>

    <?= $settings['footer_code'] ?>
    <script src="<?= base_url() ?>assets/libs/jquery/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?= base_url() ?>assets/js/vie/captcha.js"></script>
</body>
</html>