<?php if ($settings['faucet_top_ad']) { ?>
    <div class="ads mb-4 text-center">
        <?= $settings['faucet_top_ad'] ?>
    </div>
<?php } ?>

<div class="row g-4">
    <!-- Info Boxes -->
    <div class="col-md-6 col-xl-3">
        <div class="dashboard-card p-4 hover-lift">
            <div class="d-flex align-items-center gap-3">
                <div class="feature-icon small bg-primary bg-opacity-10">
                    <i class="fas fa-clock text-gradient"></i>
                </div>
                <div>
                    <h5 class="text-secondary small text-uppercase mb-1 tracking-wider">Claim Timer</h5>
                    <h3 class="text-white mb-0 fw-bold">
                        <?php if ($wait) { ?>
                            <span id="minute"><?= floor($wait / 60) ?></span>:<span id="second"><?= $wait % 60 ?></span>
                        <?php } else { ?>
                            Ready
                        <?php } ?>
                    </h3>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-6 col-xl-3">
        <div class="dashboard-card p-4 hover-lift">
            <div class="d-flex align-items-center gap-3">
                <div class="feature-icon small bg-info bg-opacity-10">
                    <i class="fas fa-hourglass-half text-info"></i>
                </div>
                <div>
                    <h5 class="text-secondary small text-uppercase mb-1 tracking-wider">Interval</h5>
                    <h3 class="text-white mb-0 fw-bold"><?= floor($settings['timer'] / 60) ?> Min</h3>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-6 col-xl-3">
        <div class="dashboard-card p-4 hover-lift">
            <div class="d-flex align-items-center gap-3">
                <div class="feature-icon small bg-warning bg-opacity-10">
                    <i class="fas fa-gift text-warning"></i>
                </div>
                <div>
                    <h5 class="text-secondary small text-uppercase mb-1 tracking-wider">Reward</h5>
                    <h3 class="text-white mb-0 fw-bold"><?= currencyDisplay($settings['reward'], $settings) ?></h3>
                    <?php if ($bonus > 0) echo '<p class="text-success smaller mb-0">+' . $bonus . '% Bonus</p>'; ?>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-6 col-xl-3">
        <div class="dashboard-card p-4 hover-lift">
            <div class="d-flex align-items-center gap-3">
                <div class="feature-icon small bg-danger bg-opacity-10">
                    <i class="fas fa-fire text-danger"></i>
                </div>
                <div>
                    <h5 class="text-secondary small text-uppercase mb-1 tracking-wider">Daily Limit</h5>
                    <h3 class="text-white mb-0 fw-bold"><?= $countHistory ?> / <?= $settings['daily_limit'] ?></h3>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row g-4 mt-2 justify-content-center">
    <div class="col-lg-8">
        <!-- Progress Requirement Card -->
        <div class="dashboard-card p-4 mb-4 border-info border-opacity-10">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h6 class="text-info mb-0 fw-bold"><i class="fas fa-tasks me-2"></i> PTC Requirement</h6>
                <span class="text-white small fw-bold"><?= $ptc_done_today ?> / <?= $ptc_required ?> Completed</span>
            </div>
            <div class="progress rounded-pill bg-white bg-opacity-5" style="height: 10px;">
                <?php $ptc_percent = ($ptc_required > 0) ? min(100, ($ptc_done_today / $ptc_required) * 100) : 100; ?>
                <div class="progress-bar progress-bar-striped progress-bar-animated bg-info" role="progressbar" style="width: <?= $ptc_percent ?>%"></div>
            </div>
            <?php if ($ptc_done_today < $ptc_required): ?>
                <p class="text-secondary smaller mt-2 italic mb-0"><i class="fas fa-info-circle me-1"></i> You must view <?= $ptc_required ?> PTC ads before claiming from this faucet.</p>
            <?php endif; ?>
        </div>

        <div class="dashboard-card p-4 p-md-5 text-center position-relative overflow-hidden">
            <div class="mb-5">
                <h2 class="text-white mb-2">Claim Your Coinz</h2>
                <p class="text-secondary small">Solve the security check below to collect your reward.</p>
            </div>

            <?php if (isset($_SESSION['message'])) echo '<div class="mb-4 text-start">' . $_SESSION['message'] . '</div>'; ?>

            <?php if ($limit): ?>
                <div class="alert alert-warning border-0 bg-warning bg-opacity-10 text-warning p-4 rounded-4">
                    <i class="fas fa-exclamation-triangle fa-2x mb-3 d-block"></i>
                    <h5 class="fw-bold">Daily Limit Reached!</h5>
                    <p class="mb-0">You have completed all claims for today. Please check back tomorrow or visit the Shortlink wall for more energy.</p>
                </div>
            <?php elseif ($wait): ?>
                <div class="alert alert-info border-0 bg-info bg-opacity-10 text-info p-4 rounded-4">
                    <i class="fas fa-clock fa-2x mb-3 d-block"></i>
                    <h5 class="fw-bold">Faucet on Cooldown</h5>
                    <p class="mb-0">Please wait for the timer to reset before your next claim.</p>
                </div>
                <script type="text/javascript">var wait = <?= $wait ?> - 1;</script>
            <?php else: ?>
                <form action="<?= site_url('/faucet2/verify') ?>" method="POST" id="faucetForm">
                    <input type="hidden" name="<?= $csrf_name ?>" id="token" value="<?= $csrf_hash ?>">
                    
                    <?php if ($settings['antibotlinks'] == 'on'): ?>
                        <div class="antibot-container p-4 rounded-4 bg-white bg-opacity-5 border border-white border-opacity-5 mb-5">
                            <h6 class="text-secondary smaller text-uppercase fw-bold mb-3 tracking-wider">Select in order:</h6>
                            <?= $antibot_show_info ?>
                            <div class="d-flex flex-wrap justify-content-center gap-3 mt-4">
                                <?php for($i=0; $i<=5; $i++): ?>
                                    <?php if(in_array($i, $anti_pos)) echo '<div class="antibotlinks"></div>'; ?>
                                <?php endfor; ?>
                            </div>
                        </div>
                    <?php endif; ?>

                    <div class="captcha-box mb-5 p-3 bg-white bg-opacity-5 rounded-4 border border-white border-opacity-5">
                        <?= $captcha_display ?>
                    </div>

                    <button type="submit" class="btn-primary-custom w-100 py-3 rounded-pill shadow-lg claim-button" disabled>
                        <i class="fas fa-coins me-2"></i> Collect Your Reward <?= ($useEnergy) ? '(-' . $settings['faucet_cost'] . ' Energy)' : '' ?>
                    </button>
                </form>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php if ($settings['faucet_footer_ad']) { ?>
    <div class="ads mt-4 text-center"><?= $settings['faucet_footer_ad'] ?></div>
<?php } ?>

<style>
    .smaller { font-size: 0.75rem; }
    .italic { font-style: italic; }
    .antibotlinks {
        display: inline-block;
        padding: 5px;
        background: rgba(255,255,255,0.05);
        border: 1px solid rgba(255,255,255,0.1);
        border-radius: 8px;
        cursor: pointer;
        transition: var(--transition);
    }
    .antibotlinks:hover { background: rgba(var(--primary-rgb), 0.2); border-color: var(--primary); }
    .antibotlinks img { filter: invert(1); max-height: 40px; }
</style>