<?php if ($settings['dashboard_top_ad']) { ?>
    <div class="ads mb-4 text-center">
        <?= $settings['dashboard_top_ad'] ?>
    </div>
<?php } ?>

<script id="aclib" type="text/javascript" src="//acscdn.com/script/aclib.js"></script>

<?php if ($user['verified'] == 0) { ?>
    <div class="alert alert-warning border-0 bg-warning bg-opacity-10 text-warning p-3 rounded-4 mb-4 d-flex align-items-center justify-content-between">
        <div class="d-flex align-items-center gap-3">
            <i class="fas fa-envelope-open-text fa-lg"></i>
            <span class="small fw-bold">Please check your email for a verification link. <a href="<?= site_url('dashboard/resend') ?>" class="text-warning text-decoration-underline">Resend Email</a></span>
        </div>
        <button type="button" class="btn-close btn-close-white small" data-bs-dismiss="alert"></button>
    </div>
<?php } ?>

<!-- Top Quick Stats -->
<div class="row g-4 mb-5">
    <div class="col-md-4">
        <div class="dashboard-card p-4 hover-lift h-100">
            <div class="d-flex align-items-center gap-3">
                <div class="feature-icon small bg-primary bg-opacity-10 mb-0">
                    <i class="fas fa-wallet text-gradient"></i>
                </div>
                <div>
                    <h5 class="text-secondary smaller text-uppercase mb-1 tracking-wider fw-bold">Main Balance</h5>
                    <h3 class="text-white mb-0 fw-bold"><?= currencyDisplay($user['balance'], $settings) ?></h3>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="dashboard-card p-4 hover-lift h-100">
            <div class="d-flex align-items-center gap-3">
                <div class="feature-icon small bg-info bg-opacity-10 mb-0">
                    <i class="fas fa-bolt text-info"></i>
                </div>
                <div>
                    <h5 class="text-secondary smaller text-uppercase mb-1 tracking-wider fw-bold">Energy Pool</h5>
                    <h3 class="text-white mb-0 fw-bold"><?= number_format($user['energy']) ?></h3>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="dashboard-card p-4 hover-lift h-100">
            <div class="d-flex align-items-center gap-3">
                <div class="feature-icon small bg-warning bg-opacity-10 mb-0">
                    <i class="fas fa-vault text-warning"></i>
                </div>
                <div>
                    <h5 class="text-secondary smaller text-uppercase mb-1 tracking-wider fw-bold">Ad Balance</h5>
                    <h3 class="text-white mb-0 fw-bold"><?= currencyDisplay($user['dep_balance'], $settings) ?></h3>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row g-4 mb-5">
    <!-- Welcome & Profile Summary -->
    <div class="col-lg-7">
        <div class="dashboard-card p-4 p-md-5 h-100 position-relative overflow-hidden">
            <div class="position-absolute top-0 end-0 p-4 opacity-10">
                <i class="fas fa-user-astronaut fa-8x text-white"></i>
            </div>
            
            <div class="d-flex align-items-center gap-4 mb-5 position-relative">
                <div class="avatar-wrapper p-1 rounded-circle bg-gradient-primary" style="width: 80px; height: 80px;">
                    <img src="<?= base_url() ?>assets/coinzi/dash/img/hacker.png" class="img-fluid rounded-circle bg-dark p-1" alt="User">
                </div>
                <div>
                    <h2 class="text-white mb-1 fw-bold">Welcome Back, <?= $user['username'] ?>!</h2>
                    <p class="text-secondary small mb-0">Ranked #<?= $leaderboardRank ?? 'N/A' ?> in global earnings</p>
                </div>
            </div>

            <div class="row g-4 mb-5 position-relative">
                <div class="col-6 col-md-3">
                    <h6 class="text-secondary smaller text-uppercase mb-1">Current Level</h6>
                    <h4 class="text-white fw-bold mb-0"><?= $user['level'] ?></h4>
                </div>
                <div class="col-6 col-md-3">
                    <h6 class="text-secondary smaller text-uppercase mb-1">Referrals</h6>
                    <h4 class="text-white fw-bold mb-0"><?= $referralCount ?></h4>
                </div>
                <div class="col-6 col-md-3">
                    <h6 class="text-secondary smaller text-uppercase mb-1">Experience</h6>
                    <h4 class="text-white fw-bold mb-0"><?= number_format($user['exp']) ?></h4>
                </div>
                <div class="col-6 col-md-3">
                    <h6 class="text-secondary smaller text-uppercase mb-1">Life Gains</h6>
                    <h4 class="text-success fw-bold mb-0"><?= currencyDisplay($user["total_earned"], $settings) ?></h4>
                </div>
            </div>

            <div class="progress-section">
                <div class="d-flex justify-content-between align-items-center mb-2">
                    <span class="text-secondary smaller text-uppercase fw-bold">Level Progression</span>
                    <span class="text-white small fw-bold"><?= ($user['exp'] % 100) ?>%</span>
                </div>
                <div class="progress rounded-pill bg-white bg-opacity-5" style="height: 10px;">
                    <div class="progress-bar progress-bar-striped progress-bar-animated bg-primary" 
                         role="progressbar" style="width: <?= ($user['exp'] % 100) ?>%"></div>
                </div>
                <p class="text-secondary smaller mt-2 text-end mb-0">Next Level: <span class="text-white fw-bold"><?= ($user['level'] + 1) * 100 - $user['exp'] ?> EXP</span> needed</p>
            </div>
        </div>
    </div>

    <!-- Daily Activities / Right Side -->
    <div class="col-lg-5">
        <!-- Daily Bonus Card -->
        <div class="dashboard-card p-4 p-md-5 h-100 d-flex flex-column justify-content-between border-info border-opacity-20" style="background: radial-gradient(circle at top right, rgba(13, 110, 253, 0.1), transparent), rgba(var(--bg-card-rgb), 1);">
            <div class="text-center mb-4">
                <div class="feature-icon mx-auto bg-info bg-opacity-10 mb-3" style="width: 70px; height: 70px;">
                    <i class="fas fa-gift text-info fa-lg"></i>
                </div>
                <h3 class="text-white mb-2 fw-bold">Daily Streak Reward</h3>
                <p class="text-secondary small">Maintain your activity streak to earn multiplying rewards and energy boosts.</p>
            </div>

            <div class="bonus-details mb-4">
                <div class="d-flex justify-content-between align-items-center p-3 rounded-4 bg-white bg-opacity-5 border border-white border-opacity-5 mb-3">
                    <span class="text-secondary small"><i class="fas fa-chart-line me-2 text-success"></i> Current Bonus</span>
                    <span class="text-success fw-bold"><?= $bonus ?>% Faster</span>
                </div>
                <div class="d-flex justify-content-between align-items-center p-3 rounded-4 bg-white bg-opacity-5 border border-white border-opacity-5">
                    <span class="text-secondary small"><i class="fas fa-star me-2 text-warning"></i> Next Level Perk</span>
                    <span class="text-white fw-bold">+<?= $settings['level_bonus'] ?>% Bonus</span>
                </div>
            </div>

            <form action="<?= site_url('/bonus/claim') ?>" method="POST" class="w-100">
                <input type="hidden" name="<?= $csrf_name ?>" id="token" value="<?= $csrf_hash ?>">
                <button type="submit" class="btn-primary-custom w-100 py-3 rounded-pill shadow-lg <?= $bonusAvailable ? '' : 'disabled bg-secondary' ?>" <?= $bonusAvailable ? '' : 'disabled' ?>>
                    <i class="far fa-check-circle me-2"></i> <?= $bonusAvailable ? 'Claim Daily Bonus' : 'Already Claimed' ?>
                </button>
            </form>
        </div>
    </div>
</div>

<!-- Telegram Hub Banner -->
<div class="row g-4 mb-5">
    <div class="col-12">
        <a href="https://t.me/coinzi_announcements" target="_blank" class="text-decoration-none">
            <div class="dashboard-card p-4 d-flex flex-wrap align-items-center justify-content-between gap-3 border-info border-opacity-20 hover-lift" style="background: linear-gradient(to right, rgba(0, 136, 204, 0.2), transparent);">
                <div class="d-flex align-items-center gap-3">
                    <div class="feature-icon small bg-info bg-opacity-20 mb-0">
                        <i class="fab fa-telegram-plane"></i>
                    </div>
                    <div>
                        <h5 class="text-white mb-0 fw-bold">Flash Coupon Event</h5>
                        <p class="text-secondary smaller mb-0">Join our official Telegram for daily exclusive promo codes and announcements.</p>
                    </div>
                </div>
                <span class="btn btn-info btn-sm rounded-pill px-4 py-2 text-white fw-bold">JOIN COMMUNITY <i class="fas fa-chevron-right ms-2 smaller"></i></span>
            </div>
        </a>
    </div>
</div>

<!-- Featured Offerwalls Grid -->
<div class="row g-4">
    <div class="col-12 mb-2 d-flex align-items-center justify-content-between">
        <h4 class="text-white mb-0 fw-bold">Featured Partners</h4>
        <a href="<?= site_url('offerwalls') ?>" class="text-primary smaller text-decoration-none fw-bold">View All Walls <i class="fas fa-arrow-right ms-1"></i></a>
    </div>

    <?php 
    $walls = [
        ['id' => 'gemiad', 'name' => 'GemiAd', 'logo' => 'gemiad.svg', 'tags' => ['PTC', 'Links', 'Games'], 'bonus' => '50%'],
        ['id' => 'monlix', 'name' => 'Monlix', 'logo' => 'monlix.svg', 'tags' => ['Surveys', 'Apps'], 'bonus' => 'Auto'],
        ['id' => 'timewall', 'name' => 'TimeWall', 'logo' => 'time.png', 'tags' => ['Daily Tasks', 'Clicks'], 'bonus' => 'Fast']
    ];
    foreach($walls as $wall): 
        if ($settings[$wall['id'].'_status'] == 'off') continue;
    ?>
    <div class="col-md-6 col-xl-4">
        <div class="dashboard-card p-4 hover-lift h-100 d-flex flex-column justify-content-between">
            <div class="position-relative">
                <div class="d-flex justify-content-between align-items-start mb-4">
                    <div class="partner-logo bg-white bg-opacity-5 p-3 rounded-4" style="height: 60px; min-width: 120px; display: flex; align-items: center; justify-content: center;">
                        <img src="<?= base_url() ?>assets/coinzi/dash/img/<?= $wall['logo'] ?>" class="img-fluid" alt="<?= $wall['name'] ?>" style="max-height: 35px;">
                    </div>
                    <span class="badge rounded-pill bg-danger bg-opacity-10 text-danger border border-danger border-opacity-10 px-2 py-1 smaller pulse">
                        <?= $wall['bonus'] ?> BONUS
                    </span>
                </div>
                
                <h5 class="text-white fw-bold mb-3"><?= $wall['name'] ?> Wall</h5>
                
                <div class="d-flex flex-wrap gap-2 mb-4">
                    <?php foreach($wall['tags'] as $tag): ?>
                        <span class="badge rounded-pill bg-white bg-opacity-5 text-secondary border border-white border-opacity-10 px-2 py-1 smaller"><?= $tag ?></span>
                    <?php endforeach; ?>
                </div>

                <div class="star-rating text-warning small mb-4 opacity-75">
                    <i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i>
                </div>
            </div>

            <a href="<?= site_url('offerwall/'.$wall['id']) ?>" class="btn-primary-custom w-100 py-2 rounded-pill fw-bold text-center">Open Offerwall</a>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<!-- Modal Logic (Hidden but present for system behavior if needed) -->
<div id="exampleModal" class="modal fade" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content dashboard-card p-4 text-center border-primary border-opacity-20">
            <div class="modal-body py-4">
                <div class="feature-icon mx-auto bg-primary bg-opacity-10 mb-4" style="width: 80px; height: 80px;">
                    <i class="fas fa-trophy text-gradient fa-2x"></i>
                </div>
                <h2 class="text-white fw-bold mb-3 text-gradient">Referral Legends</h2>
                <p class="text-secondary small mb-4">Join our $50 weekly referral leaderboard. Refer friends and climb to top 5 to receive guaranteed BTC rewards!</p>
                
                <div class="p-3 bg-white bg-opacity-5 rounded-4 border border-white border-opacity-5 mb-4">
                    <div class="d-flex justify-content-between mb-2 small fw-bold">
                        <span class="text-warning">#1 Prize</span>
                        <span class="text-white">$25.00</span>
                    </div>
                    <div class="d-flex justify-content-between mb-2 small fw-bold">
                        <span class="text-secondary">#2 Prize</span>
                        <span class="text-white">$15.00</span>
                    </div>
                </div>
                
                <div class="d-flex gap-2">
                    <button type="button" class="btn btn-dark rounded-pill px-4 flex-grow-1" data-bs-dismiss="modal">Close</button>
                    <a href="<?= site_url('leaderboard') ?>" class="btn-primary-custom flex-grow-1">Leaderboard</a>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .bg-gradient-primary { background: linear-gradient(135deg, var(--primary), #7b2cbf); }
    .pulse { animation: badge-pulse-red 2.5s infinite ease-in-out; }
    @keyframes badge-pulse-red {
        0%, 100% { transform: scale(1); box-shadow: 0 0 0 rgba(220, 53, 69, 0); }
        50% { transform: scale(1.05); box-shadow: 0 0 10px rgba(220, 53, 69, 0.3); }
    }
    .smaller { font-size: 0.75rem; }
    .z-idx-10 { z-index: 10; }
    .partner-logo { transition: all 0.3s ease; }
    .dashboard-card:hover .partner-logo { background: rgba(255, 255, 255, 0.1) !important; }
</style>

<script>
    $(document).ready(function() {
        // Only show if it matches some user state or first load
        <?php if (!isset($_SESSION['modal_shown'])): ?>
            setTimeout(function() {
                $('#exampleModal').modal('show');
            }, 3000);
            <?php $_SESSION['modal_shown'] = true; ?>
        <?php endif; ?>
    });
</script>