<div class="row g-4 justify-content-center">
    <!-- Header Section -->
    <div class="col-lg-12">
        <div class="dashboard-card p-4" style="background: var(--primary-gradient); border: none;">
            <div class="row align-items-center">
                <div class="col-md-8">
                    <h2 class="text-white mb-2"><i class="fas fa-fire me-2"></i>Daily Streak Bonus</h2>
                    <p class="text-white-50 mb-0">Maintain your streak to earn bigger rewards! Resets in <span id="streak-timer" class="fw-bold text-white">--:--:--</span></p>
                </div>
                <div class="col-md-4 text-md-end mt-3 mt-md-0">
                    <div class="streak-badge px-4 py-2 bg-white bg-opacity-10 rounded-pill border border-white border-opacity-25 d-inline-block">
                        <span class="text-white small text-uppercase fw-bold">Current Streak: </span>
                        <span class="text-white fw-bold ms-1"><?= $streak['current_day'] ?? 0 ?> Days</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Progress Card -->
    <div class="col-lg-8">
        <div class="dashboard-card">
            <?php
            $earned = $user['earned_today'] ?? 0;
            $target = $settings['req_earnings'] ?? 0.10;
            $progress = $target > 0 ? min(100, ($earned / $target) * 100) : 0;
            ?>
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4 class="text-white mb-0">Requirement Progress</h4>
                <span class="text-gradient fw-bold"><?= number_format($progress, 1) ?>%</span>
            </div>
            
            <div class="progress mb-3" style="height: 12px; background: rgba(255,255,255,0.05); border-radius: 10px;">
                <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" 
                     style="width: <?= $progress ?>%; background: var(--primary-gradient); border-radius: 10px;"></div>
            </div>
            
            <div class="d-flex justify-content-between align-items-center">
                <p class="text-secondary small mb-0">
                    <i class="fas fa-info-circle me-1"></i> Earned: <span class="text-white fw-bold"><?= currencyDisplay($earned, $settings) ?></span> / Required: <span class="text-white fw-bold"><?= currencyDisplay($target, $settings) ?></span>
                </p>
                <?php if ($progress < 100): ?>
                    <span class="badge bg-warning text-dark px-3 rounded-pill small">Incomplete</span>
                <?php else: ?>
                    <span class="badge bg-success text-white px-3 rounded-pill small">Ready to Claim</span>
                <?php endif; ?>
            </div>

            <hr class="border-secondary opacity-25 my-4">

            <div class="streak-grid">
                <?php 
                $today = date('Y-m-d');
                $last_claim = $streak['last_claim'] ?? null;
                $current_day = $streak['current_day'] ?? 0;
                
                if ($last_claim === null) {
                    $claimable_day = 1;
                    $current_day = 0;
                } elseif ($last_claim == $today) {
                    $claimable_day = 0; 
                } elseif ($last_claim == date('Y-m-d', strtotime('-1 day'))) {
                    if ($current_day >= 7) {
                        $claimable_day = 1;
                        $current_day = 0;
                    } else {
                        $claimable_day = $current_day + 1;
                    }
                } else {
                    $claimable_day = 1;
                    $current_day = 0;
                }

                $day7_rewards = array_filter($rewards, function($r) {
                    return $r['day'] == 7;
                });

                foreach ($rewards as $reward): 
                    $day = $reward['day'];
                    if ($day == 7 && $reward !== reset($day7_rewards)) continue;

                    $status_class = '';
                    $icon = 'fa-lock';
                    $displayText = currencyDisplay($reward['reward'], $settings);

                    if ($day <= $current_day) {
                        $status_class = 'completed';
                        $icon = 'fa-check-circle';
                        $displayText = 'Claimed';
                    } elseif ($day == $claimable_day) {
                        $status_class = 'active-day pulse-primary';
                        $icon = 'fa-gift';
                        if ($day == 7) $displayText = "Up to " . currencyDisplay($max_reward, $settings);
                    } else {
                        if ($day == 7) $displayText = "Up to " . currencyDisplay($max_reward, $settings);
                    }
                ?>
                    <div class="streak-day-item <?= $status_class ?> <?= $day == 7 ? 'big-day' : '' ?>">
                        <span class="day-label">Day <?= $day ?></span>
                        <div class="day-icon"><i class="fas <?= $icon ?>"></i></div>
                        <span class="day-reward"><?= $displayText ?></span>
                    </div>
                <?php endforeach; ?>
            </div>

            <div class="text-center mt-5">
                <form action="<?= site_url('daily_streak/claim') ?>" method="post" id="daily-streak-form">
                    <input type="hidden" name="<?= $csrf_name ?>" value="<?= $csrf_hash ?>">
                    <button type="submit" class="btn-primary-custom px-5 py-3" id="claimBtn"
                        <?= (isset($streak['last_claim']) && $streak['last_claim'] == date('Y-m-d')) ? 'disabled' : '' ?>>
                        <i class="fas fa-star me-2"></i>
                        <?php if (isset($streak['last_claim']) && $streak['last_claim'] == date('Y-m-d')): ?>
                            Already Claimed Today
                        <?php else: ?>
                            Claim Today's Reward
                        <?php endif; ?>
                    </button>
                </form>
            </div>
        </div>
    </div>

    <!-- Info Card -->
    <div class="col-lg-4">
        <div class="dashboard-card">
            <h4 class="text-white mb-4"><i class="fas fa-question-circle text-gradient me-2"></i>How it works?</h4>
            
            <div class="info-item mb-4">
                <div class="d-flex align-items-start gap-3">
                    <div class="info-icon"><i class="fas fa-coins text-warning"></i></div>
                    <div>
                        <h6 class="text-white mb-1">Earn Minimum Reward</h6>
                        <p class="text-secondary small">You need to earn at least <span class="text-white"><?= currencyDisplay($target, $settings) ?></span> from any method today to unlock the claim button.</p>
                    </div>
                </div>
            </div>

            <div class="info-item mb-4">
                <div class="d-flex align-items-start gap-3">
                    <div class="info-icon"><i class="fas fa-calendar-check text-success"></i></div>
                    <div>
                        <h6 class="text-white mb-1">Daily Check-in</h6>
                        <p class="text-secondary small">Come back every 24 hours to claim your bonus. Missing a single day will reset your streak to Day 1!</p>
                    </div>
                </div>
            </div>

            <div class="info-item">
                <div class="d-flex align-items-start gap-3">
                    <div class="info-icon"><i class="fas fa-gem text-primary"></i></div>
                    <div>
                        <h6 class="text-white mb-1">Day 7 Jackpot</h6>
                        <p class="text-secondary small mb-3">On the 7th day, you get a chance to win massive rewards based on these probabilities:</p>
                        <div class="p-3 rounded-4 bg-white bg-opacity-5 border border-white border-opacity-10">
                            <?php foreach ($day7_probs as $p): ?>
                                <div class="d-flex justify-content-between mb-1 small">
                                    <span class="text-secondary"><?= $p['chance'] ?>% chance</span>
                                    <span class="text-white fw-bold"><?= currencyDisplay($p['reward'], $settings) ?></span>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .streak-grid {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 15px;
        margin-top: 20px;
    }

    .streak-day-item {
        background: rgba(255, 255, 255, 0.03);
        border: 1px solid rgba(255, 255, 255, 0.05);
        border-radius: 15px;
        padding: 20px 10px;
        text-align: center;
        transition: var(--transition);
        display: flex;
        flex-direction: column;
        align-items: center;
        gap: 8px;
    }

    .streak-day-item.big-day {
        grid-column: span 3;
        background: linear-gradient(135deg, rgba(240, 5, 193, 0.1), rgba(157, 78, 221, 0.1));
        border: 1px solid var(--border-color);
    }

    .streak-day-item.completed {
        background: rgba(40, 167, 69, 0.1);
        border-color: rgba(40, 167, 69, 0.2);
    }

    .streak-day-item.completed .day-icon {
        color: #28a745;
    }

    .streak-day-item.active-day {
        background: var(--primary-gradient);
        border: none;
        box-shadow: var(--shadow-primary);
        transform: scale(1.02);
    }

    .streak-day-item.active-day .day-label,
    .streak-day-item.active-day .day-reward,
    .streak-day-item.active-day .day-icon {
        color: #fff !important;
    }

    .day-label {
        font-size: 0.75rem;
        text-transform: uppercase;
        letter-spacing: 1px;
        color: var(--text-muted);
        font-weight: 700;
    }

    .day-icon {
        font-size: 1.5rem;
        color: var(--text-muted);
        margin: 5px 0;
    }

    .day-reward {
        font-size: 0.9rem;
        font-weight: 800;
        color: #fff;
    }

    .info-icon {
        width: 35px;
        height: 35px;
        background: rgba(255, 255, 255, 0.05);
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1rem;
    }

    .pulse-primary {
        animation: pulse-primary 2s infinite;
    }

    @keyframes pulse-primary {
        0% { box-shadow: 0 0 0 0 rgba(240, 5, 193, 0.4); }
        70% { box-shadow: 0 0 0 15px rgba(240, 5, 193, 0); }
        100% { box-shadow: 0 0 0 0 rgba(240, 5, 193, 0); }
    }

    @media (max-width: 576px) {
        .streak-grid {
            grid-template-columns: repeat(2, 1fr);
        }
        .streak-day-item.big-day {
            grid-column: span 2;
        }
    }
</style>

<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
<?php if ($this->session->flashdata('sweet_alert')): 
    $sa = $this->session->flashdata('sweet_alert'); ?>
Swal.fire({
    title: "<?= $sa['title'] ?>",
    text: "<?= $sa['text'] ?>",
    icon: "<?= $sa['icon'] ?>",
    confirmButtonColor: '#f005c1',
    background: '#14141e',
    color: '#fff'
});
<?php endif; ?>

document.querySelector('#daily-streak-form').addEventListener('submit', function(e){
    const btn = this.querySelector('button[type=submit]');
    btn.disabled = true;
    btn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Processing...';
});

function updateStreakTimer() {
    let serverNow = new Date("<?= date('Y-m-d H:i:s') ?>"); 
    let clientNow = new Date();
    let offset = serverNow.getTime() - clientNow.getTime();

    setInterval(() => {
        let now = new Date(new Date().getTime() + offset);
        let midnight = new Date(now);
        midnight.setHours(24,0,0,0);
        let diff = midnight - now;

        if (diff <= 0) {
            location.reload();
        }

        let hours = Math.floor(diff / (1000*60*60));
        let minutes = Math.floor((diff % (1000*60*60)) / (1000*60));
        let seconds = Math.floor((diff % (1000*60)) / 1000);

        document.getElementById('streak-timer').textContent =
            `${hours.toString().padStart(2,'0')}:${minutes.toString().padStart(2,'0')}:${seconds.toString().padStart(2,'0')}`;
    }, 1000);
}

updateStreakTimer();
</script>