<?php if ($settings['coinflip_top_ad']) { ?>
    <div class="ads mb-4 text-center">
        <?= $settings['coinflip_top_ad'] ?>
    </div>
<?php } ?>

<div class="row g-4 justify-content-center">
    <!-- Main Game Card -->
    <div class="col-lg-12">
        <div class="dashboard-card p-4 p-md-5">
            <div class="d-flex align-items-center gap-3 mb-5">
                <div class="feature-icon small bg-primary bg-opacity-10">
                    <i class="fas fa-coins text-gradient"></i>
                </div>
                <div>
                    <h2 class="text-white mb-0 uppercase tracking-widest">Coin Flip</h2>
                    <p class="text-secondary small mb-0">Choose your side and double your stake.</p>
                </div>
            </div>

            <div class="row g-5 align-items-center">
                <!-- Betting Column -->
                <div class="col-lg-6">
                    <form id="betForm">
                        <div id="result" class="mb-4"></div>

                        <div class="mb-4">
                            <label class="text-secondary small text-uppercase fw-bold mb-2 d-block">Bet Amount</label>
                            <div class="input-group">
                                <span class="input-group-text border-0 bg-white bg-opacity-5 text-secondary px-3"><i class="fas fa-wallet small"></i></span>
                                <input type="number" class="form-control border-0 bg-white bg-opacity-5 text-white p-3" id="betAmount" 
                                       value="<?= $settings['coinflip_min_bet'] / $settings['currency_rate'] ?>" 
                                       min="<?= $settings['coinflip_min_bet'] / $settings['currency_rate'] ?>" 
                                       max="<?= $settings['coinflip_max_bet'] / $settings['currency_rate'] ?>" step="1">
                                <button type="button" id="half" class="btn btn-dark border-start border-white border-opacity-10 px-3">/2</button>
                                <button type="button" id="double" class="btn btn-dark border-start border-white border-opacity-10 px-3">x2</button>
                            </div>
                            <div class="mt-2 text-end">
                                <small class="text-secondary smaller">Min Bet: <?= currencyDisplay($settings['coinflip_min_bet'], $settings) ?></small>
                            </div>
                        </div>

                        <div class="row g-3">
                            <div class="col-6">
                                <button type="submit" id="betBTC" class="btn btn-warning w-100 py-3 rounded-pill shadow-lg d-flex flex-column align-items-center justify-content-center gap-2 bet-btn" data-coin="BTC" style="background: linear-gradient(135deg, #f7931a, #ffab40) !important; color: #fff; border: none;">
                                    <i class="fab fa-bitcoin fa-2x"></i>
                                    <span class="fw-bold tracking-wider small">BITCOIN</span>
                                </button>
                            </div>
                            <div class="col-6">
                                <button type="submit" id="betETH" class="btn btn-info w-100 py-3 rounded-pill shadow-lg d-flex flex-column align-items-center justify-content-center gap-2 bet-btn" data-coin="ETH" style="background: linear-gradient(135deg, #627eea, #3c3c3d) !important; color: #fff; border: none;">
                                    <i class="fab fa-ethereum fa-2x"></i>
                                    <span class="fw-bold tracking-wider small">ETHEREUM</span>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>

                <!-- Animation Column -->
                <div class="col-lg-6">
                    <div class="flip-stage py-5 rounded-4 bg-white bg-opacity-5 border border-white border-opacity-5 d-flex align-items-center justify-content-center position-relative overflow-hidden" style="min-height: 250px; background: radial-gradient(circle at center, rgba(157, 78, 221, 0.1) 0%, rgba(0,0,0,0) 70%);">
                        <div id="coinflip" class="position-relative" style="width: 150px; height: 150px;">
                            <div id="bitcoin" class="position-absolute w-100 h-100 rounded-circle shadow-lg" style="background: radial-gradient(circle, #f7931a, #8b4513); border: 4px solid rgba(255,255,255,0.2); display: flex; align-items: center; justify-content: center; transform-style: preserve-3d; transition: transform 0.6s;">
                                <i class="fab fa-bitcoin text-white" style="font-size: 80px;"></i>
                            </div>
                            <div id="ethereum" class="position-absolute w-100 h-100 rounded-circle shadow-lg" style="background: radial-gradient(circle, #627eea, #3c3c3d); border: 4px solid rgba(255,255,255,0.2); display: flex; align-items: center; justify-content: center; transform-style: preserve-3d; transition: transform 0.6s; backface-visibility: hidden;">
                                <i class="fab fa-ethereum text-white" style="font-size: 80px;"></i>
                            </div>
                        </div>
                        <div class="scanline position-absolute w-100 opacity-10" style="height: 100%; background: linear-gradient(transparent, rgba(255,255,255,0.05) 50%, transparent); pointer-events: none;"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- History Card -->
    <div class="col-lg-12">
        <div class="dashboard-card p-4">
            <h5 class="text-white mb-4"><i class="fas fa-history text-primary me-2"></i> Recent Game History</h5>
            <div class="table-responsive">
                <table class="table table-dark table-hover border-white border-opacity-5 text-center align-middle">
                    <thead class="bg-white bg-opacity-5">
                        <tr class="text-secondary small text-uppercase">
                            <th class="border-0">Game ID</th>
                            <th class="border-0">Bet Details</th>
                            <th class="border-0">Result</th>
                            <th class="border-0 text-end">Profit</th>
                        </tr>
                    </thead>
                    <tbody id="coinflipHistory" class="text-white border-0">
                        <?php if (empty($history)): ?>
                            <tr><td colspan="4" class="text-center py-4 text-secondary italic border-0">No games played yet.</td></tr>
                        <?php else: ?>
                            <?php foreach ($history as $flip): 
                                $isWin = $flip['profit'] > 0;
                                $isBTC = strtoupper($flip['coin']) == 'BTC';
                                $resBTC = strtoupper($flip['result']) == 'BTC';
                            ?>
                                <tr class="transition">
                                    <td class="border-0 py-3 font-monospace small">#<?= $flip["id"] ?></td>
                                    <td class="border-0 py-3">
                                        <div class="d-flex align-items-center justify-content-center gap-2">
                                            <span class="fw-bold"><?= currencyDisplay($flip['bet_amount'], $settings) ?></span>
                                            <i class="fab fa-<?= $isBTC ? 'bitcoin text-warning' : 'ethereum text-info' ?> small"></i>
                                        </div>
                                    </td>
                                    <td class="border-0 py-3">
                                        <span class="badge rounded-pill bg-white bg-opacity-5 text-<?= $resBTC ? 'warning' : 'info' ?> border border-white border-opacity-10 px-3 py-1">
                                            <i class="fab fa-<?= $resBTC ? 'bitcoin' : 'ethereum' ?> me-1"></i> <?= strtoupper($flip['result']) ?>
                                        </span>
                                    </td>
                                    <td class="border-0 py-3 text-end fw-bold <?= $isWin ? 'text-success' : 'text-danger' ?>">
                                        <?= ($isWin ? '+' : '') . currencyDisplay($flip['profit'], $settings) ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php if ($settings['coinflip_footer_ad']) { ?>
    <div class="ads mt-4 text-center"><?= $settings['coinflip_footer_ad'] ?></div>
<?php } ?>

<script>
    var rate = <?= $settings['currency_rate'] ?>;
</script>

<style>
    .smaller { font-size: 0.75rem; }
    .bet-btn:hover { transform: translateY(-3px) scale(1.02); }
    .flip-stage { box-shadow: inset 0 0 50px rgba(0,0,0,0.5); }
    #coinflip { transform-style: preserve-3d; transition: transform 0.6s cubic-bezier(0.175, 0.885, 0.32, 1.275); }
</style>