<?php if ($settings['autofaucet_top_ad']) { ?>
    <div class="ads mb-4 text-center">
        <?= $settings['autofaucet_top_ad'] ?>
    </div>
<?php } ?>

<div class="row g-4 justify-content-center pt-5">
    <div class="col-lg-8">
        <div class="dashboard-card p-4 p-md-5 text-center position-relative overflow-hidden">
            <!-- Decorative Background Element -->
            <div class="position-absolute translate-middle opacity-5" style="top: 0; right: -50px; font-size: 15rem;">
                <i class="fas fa-magic text-white"></i>
            </div>

            <div class="d-flex flex-column align-items-center mb-5">
                <div class="feature-icon large bg-primary bg-opacity-10 mb-4 pulsing">
                    <i class="fas fa-robot text-gradient"></i>
                </div>
                <h2 class="text-white mb-2">Auto Faucet</h2>
                <p class="text-secondary small">Sit back and relax. The system is automatically collecting rewards for you using your energy.</p>
            </div>

            <?php if (isset($_SESSION['message'])) echo $_SESSION['message']; ?>

            <?php if (!isset($error)): ?>
                <div class="timer-display mb-5">
                    <div class="d-flex justify-content-center align-items-baseline gap-2 mb-2">
                        <h1 class="display-3 fw-bold text-white mb-0" id="minute"><?= floor($settings['autofaucet_timer'] / 60) ?></h1>
                        <span class="text-secondary display-4">:</span>
                        <h1 class="display-3 fw-bold text-white mb-0" id="second"><?= sprintf('%02d', $settings['autofaucet_timer'] % 60) ?></h1>
                    </div>
                    <p class="text-primary-light fw-bold text-uppercase tracking-widest small">
                        Wait for <span class="text-white fw-bold"><?= currencyDisplay($settings['autofaucet_reward'], $settings) ?></span> Reward
                    </p>
                </div>

                <!-- Progress Bar -->
                <div class="px-4 mb-4">
                    <div class="progress rounded-pill bg-white bg-opacity-5 mb-2" style="height: 12px;">
                        <div class="progress-bar progress-bar-striped progress-bar-animated rounded-pill shadow-glow" 
                             id="progress" role="progressbar" style="width: 0%; background: var(--primary-gradient);"></div>
                    </div>
                    <div class="d-flex justify-content-between text-secondary smaller px-1">
                        <span>Initiated</span>
                        <span id="pct-label">0%</span>
                    </div>
                </div>

                <form action="<?= site_url('auto/verify') ?>" method="POST" id="verify">
                    <input type="hidden" name="token" value="<?= $_SESSION['autoFaucetToken'] ?>">
                </form>

                <script>
                    let timer = <?= $settings['autofaucet_timer'] ?>,
                        current = 0;
                    const autoFaucet = setInterval(function() {
                        current += 1;
                        let percent = (current * 100 / timer).toFixed(1);
                        $('#progress').css('width', percent + '%');
                        $('#pct-label').text(Math.round(percent) + '%');
                        
                        if (current >= timer) {
                            clearInterval(autoFaucet);
                            $('#verify').submit();
                        } else {
                            let wait = Math.floor(timer - current);
                            let minutes = Math.floor(wait / 60);
                            let seconds = wait % 60;
                            $('#minute').text(minutes);
                            $('#second').text(seconds < 10 ? '0' + seconds : seconds);
                        }
                    }, 1000);
                </script>
            <?php else: ?>
                <div class="py-5">
                    <div class="feature-icon large bg-danger bg-opacity-10 mb-4 mx-auto">
                        <i class="fas fa-battery-empty text-danger"></i>
                    </div>
                    <h4 class="text-white mb-3">Insufficient Energy</h4>
                    <p class="text-secondary mb-4">You need more energy to run the Auto Faucet. Visit Shortlinks or complete tasks to recharge!</p>
                    <a href="<?= site_url('links') ?>" class="btn-primary-custom px-5 py-3 rounded-pill">
                        <i class="fas fa-bolt me-2"></i> Earn Energy Now
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<style>
    .feature-icon.large {
        width: 100px;
        height: 100px;
        font-size: 2.5rem;
        display: flex;
        align-items: center;
        justify-content: center;
        border-radius: 30px;
        border: 2px solid rgba(255,255,255,0.05);
    }
    .pulsing {
        animation: pulse-glow 2s infinite ease-in-out;
    }
    @keyframes pulse-glow {
        0% { box-shadow: 0 0 0 0 rgba(157, 78, 221, 0.4); }
        70% { box-shadow: 0 0 0 20px rgba(157, 78, 221, 0); }
        100% { box-shadow: 0 0 0 0 rgba(157, 78, 221, 0); }
    }
    .shadow-glow {
        box-shadow: 0 0 15px rgba(157, 78, 221, 0.5);
    }
    .smaller { font-size: 0.75rem; }
</style>