<?php
// /application/views/user_template/account.php
$settings   = $settings ?? [];
$user       = $user ?? [];
$csrf_name  = $csrf_name ?? '';
$csrf_hash  = $csrf_hash ?? '';

$username   = htmlspecialchars($user['username'] ?? ($user['email'] ?? 'User'), ENT_QUOTES, 'UTF-8');
$tgVerified = (int)($user['telegram_verified'] ?? 0);
$tgCodeRaw  = (string)($user['telegram_token'] ?? '');
$tgCode     = htmlspecialchars($tgCodeRaw, ENT_QUOTES, 'UTF-8');
?>

<?php if (isset($settings['dashboard_top_ad']) && $settings['dashboard_top_ad']) { ?>
    <div class="ads mb-4 text-center">
        <?= $settings['dashboard_top_ad'] ?>
    </div>
<?php } ?>

<div class="row g-4">
    <!-- Telegram Verification Card -->
    <div class="col-lg-6">
        <div class="dashboard-card h-100 p-4 p-md-5">
            <div class="d-flex align-items-center gap-3 mb-4">
                <div class="feature-icon small bg-info bg-opacity-10">
                    <i class="fab fa-telegram-plane text-info"></i>
                </div>
                <div>
                    <h3 class="text-white mb-1">Telegram Security</h3>
                    <p class="text-secondary small mb-0">Link your account to enable withdrawals.</p>
                </div>
            </div>

            <div class="verification-status-box text-center p-4 rounded-4 border border-white border-opacity-5 bg-white bg-opacity-5 mb-4">
                <?php if ($tgVerified === 1): ?>
                    <div class="status-icon mb-3">
                        <i class="fas fa-check-circle text-success display-4"></i>
                    </div>
                    <h4 class="text-white">Account Verified</h4>
                    <p class="text-secondary small mb-0">Your Telegram account is successfully linked. You have full access to all platform features.</p>
                <?php else: ?>
                    <div class="status-icon mb-3">
                        <i class="fas fa-user-shield text-warning display-4"></i>
                    </div>
                    <h4 class="text-white">Pending Verification</h4>
                    <p class="text-secondary small mb-3">Please verify your account to enable withdrawal requests.</p>
                    
                    <div class="input-group mb-3">
                        <input type="text" class="form-control border-0 bg-white bg-opacity-10 text-white p-3 font-monospace" 
                               id="tgVerifyCodeInline" value="<?= $tgCode ?>" readonly>
                        <button class="btn btn-info px-4" type="button" id="tgCopyBtnInline">
                            <i class="fas fa-copy"></i>
                        </button>
                    </div>
                    <div id="tgCopyMsgInline" class="small mt-2" style="display:none;"></div>

                    <button type="button" class="btn-primary-custom w-100 mt-3" data-bs-toggle="modal" data-bs-target="#tgVerifyModal">
                        <i class="fas fa-info-circle me-2"></i> View Instructions
                    </button>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Change Password Card -->
    <div class="col-lg-6">
        <div class="dashboard-card h-100 p-4 p-md-5">
            <div class="d-flex align-items-center gap-3 mb-4">
                <div class="feature-icon small bg-primary bg-opacity-10">
                    <i class="fas fa-key text-gradient"></i>
                </div>
                <div>
                    <h3 class="text-white mb-1">Update Password</h3>
                    <p class="text-secondary small mb-0">Keep your account secure with a strong password.</p>
                </div>
            </div>

            <?php if (isset($_SESSION['message'])) echo $_SESSION['message']; ?>

            <form action="<?= site_url('account/update_password') ?>" method="POST" class="text-start">
                <input type="hidden" name="<?= $csrf_name ?>" id="token" value="<?= $csrf_hash ?>">

                <div class="mb-3">
                    <label class="text-secondary small text-uppercase fw-bold mb-2 d-block">Current Password</label>
                    <div class="input-group">
                        <span class="input-group-text border-0 bg-white bg-opacity-5 text-secondary px-3"><i class="fas fa-lock-open"></i></span>
                        <input type="password" name="old_password" class="form-control border-0 bg-white bg-opacity-5 text-white p-3" required>
                    </div>
                </div>

                <div class="mb-3">
                    <label class="text-secondary small text-uppercase fw-bold mb-2 d-block">New Password</label>
                    <div class="input-group">
                        <span class="input-group-text border-0 bg-white bg-opacity-5 text-secondary px-3"><i class="fas fa-lock"></i></span>
                        <input type="password" name="password" class="form-control border-0 bg-white bg-opacity-5 text-white p-3" required>
                    </div>
                </div>

                <div class="mb-4">
                    <label class="text-secondary small text-uppercase fw-bold mb-2 d-block">Confirm New Password</label>
                    <div class="input-group">
                        <span class="input-group-text border-0 bg-white bg-opacity-5 text-secondary px-3"><i class="fas fa-shield-alt"></i></span>
                        <input type="password" name="confirm_password" class="form-control border-0 bg-white bg-opacity-5 text-white p-3" required>
                    </div>
                </div>

                <button type="submit" class="btn-primary-custom w-100 py-3 rounded-pill">
                    <i class="fas fa-save me-2"></i> Update Security
                </button>
            </form>
        </div>
    </div>
</div>

<?php if ($tgVerified === 0): ?>
    <!-- Telegram Instructions Modal -->
    <div class="modal fade" id="tgVerifyModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content border-white border-opacity-10" style="background: rgba(20, 20, 30, 0.95); backdrop-filter: blur(20px);">
                <div class="modal-header border-white border-opacity-5 p-4">
                    <h5 class="modal-title text-white fw-bold"><i class="fab fa-telegram-plane text-info me-2"></i>Telegram Verification</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body p-4 text-start">
                    <div class="steps-container">
                        <div class="d-flex gap-3 mb-4">
                            <div class="step-num rounded-circle bg-primary bg-opacity-20 text-white d-flex align-items-center justify-content-center flex-shrink-0" style="width: 30px; height: 30px; font-weight: bold;">1</div>
                            <div>
                                <h6 class="text-white mb-2">Copy Verification Code</h6>
                                <div class="input-group mb-2">
                                    <input type="text" class="form-control border-0 bg-white bg-opacity-5 text-white" id="tgVerifyCodeModal" value="<?= $tgCode ?>" readonly>
                                    <button class="btn btn-outline-info" type="button" id="tgCopyBtnModal"><i class="fas fa-copy"></i></button>
                                </div>
                                <div id="tgCopyMsgModal" class="small" style="display:none;"></div>
                            </div>
                        </div>

                        <div class="d-flex gap-3 mb-4">
                            <div class="step-num rounded-circle bg-primary bg-opacity-20 text-white d-flex align-items-center justify-content-center flex-shrink-0" style="width: 30px; height: 30px; font-weight: bold;">2</div>
                            <div>
                                <h6 class="text-white mb-2">Open Telegram Bot</h6>
                                <p class="text-secondary small mb-3">Search for <span class="text-info fw-bold">@coinziverificationbot</span> or click the button below:</p>
                                <a href="https://t.me/coinziverificationbot" target="_blank" class="btn btn-info w-100 py-2 fw-bold text-white shadow-sm">
                                    <i class="fab fa-telegram-plane me-2"></i> Open Telegram Bot
                                </a>
                            </div>
                        </div>

                        <div class="d-flex gap-3 mb-0">
                            <div class="step-num rounded-circle bg-primary bg-opacity-20 text-white d-flex align-items-center justify-content-center flex-shrink-0" style="width: 30px; height: 30px; font-weight: bold;">3</div>
                            <div>
                                <h6 class="text-white mb-2">Complete Verification</h6>
                                <p class="text-secondary small mb-0">Send <b>/start</b> to the bot and paste your unique verification code. Refresh this page after the bot confirms success.</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer border-white border-opacity-5 p-3">
                    <button type="button" class="btn border-white border-opacity-10 text-white px-4" data-bs-dismiss="modal">I've Finished</button>
                </div>
            </div>
        </div>
    </div>

    <script>
        (function () {
            function showMsg(el, ok, message) {
                if (!el) return;
                el.style.display = 'block';
                el.className = 'small mt-1 ' + (ok ? 'text-success' : 'text-danger');
                el.textContent = message;
            }

            function copyText(text, msgEl) {
                if (!text) return;
                navigator.clipboard.writeText(text).then(function() {
                    showMsg(msgEl, true, 'Copied successfully!');
                }).catch(function() {
                    showMsg(msgEl, false, 'Failed to copy.');
                });
            }

            document.getElementById('tgCopyBtnInline')?.addEventListener('click', function() {
                copyText(document.getElementById('tgVerifyCodeInline').value, document.getElementById('tgCopyMsgInline'));
            });

            document.getElementById('tgCopyBtnModal')?.addEventListener('click', function() {
                copyText(document.getElementById('tgVerifyCodeModal').value, document.getElementById('tgCopyMsgModal'));
            });
        })();
    </script>
<?php endif; ?>

<style>
    .feature-icon.small {
        width: 45px;
        height: 45px;
        font-size: 1.25rem;
    }
    .status-icon i {
        filter: drop-shadow(0 0 15px currentColor);
    }
    .input-group-text i {
        font-size: 0.9rem;
    }
    .font-monospace {
        font-family: 'JetBrains Mono', 'Courier New', monospace !important;
        letter-spacing: 2px;
        font-size: 1.1rem !important;
    }
</style>
