<style>
    /* Correct Image Paths and Improved Styles */
    .hero-illustration img {
        content: url('<?= base_url('assets/coinzi/home/img/hero-img.png') ?>');
    }
    
    #why-us-img {
        content: url('<?= base_url('assets/coinzi/home/img/why-us-img.png') ?>');
    }

    /* Trustpilot Enhanced Styles from Original Theme */
    .trustpilot-section {
        padding: 60px 20px;
        background: transparent;
    }

    .trustpilot-container {
        max-width: 1200px;
        margin: 0 auto;
        display: grid;
        grid-template-columns: 1fr 600px;
        gap: 50px;
        align-items: center;
    }

    .trustpilot-left {
        display: flex;
        flex-direction: column;
        align-items: center;
        gap: 30px;
    }

    .reviews-illustration {
        width: 100%;
        max-width: 400px;
        height: 300px;
        background: linear-gradient(135deg, rgba(138, 43, 226, 0.2), rgba(255, 20, 147, 0.2));
        border: 2px solid rgba(255, 20, 147, 0.3);
        border-radius: 20px;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        gap: 20px;
        padding: 40px;
        backdrop-filter: blur(10px);
        position: relative;
        overflow: hidden;
    }

    .reviews-illustration::before {
        content: '';
        position: absolute;
        width: 150px;
        height: 150px;
        background: radial-gradient(circle, rgba(255, 20, 147, 0.3), transparent);
        border-radius: 50%;
        top: -50px;
        right: -50px;
        animation: pulse 3s ease-in-out infinite;
    }

    @keyframes pulse {
        0%, 100% { transform: scale(1); opacity: 0.5; }
        50% { transform: scale(1.2); opacity: 0.8; }
    }

    .illustration-icon {
        font-size: 80px;
        margin-bottom: 10px;
        filter: drop-shadow(0 0 20px rgba(255, 20, 147, 0.5));
        animation: float 3s ease-in-out infinite;
    }

    @keyframes float {
        0%, 100% { transform: translateY(0); }
        50% { transform: translateY(-10px); }
    }

    .view-reviews-btn {
        display: inline-flex;
        align-items: center;
        gap: 10px;
        background: linear-gradient(135deg, #ff1493, #8a2be2);
        color: #fff;
        padding: 16px 40px;
        border-radius: 30px;
        text-decoration: none;
        font-weight: 600;
        font-size: 16px;
        transition: all 0.3s ease;
        border: 2px solid transparent;
        box-shadow: 0 5px 20px rgba(255, 20, 147, 0.4);
    }

    .view-reviews-btn:hover {
        transform: translateY(-3px);
        box-shadow: 0 10px 30px rgba(255, 20, 147, 0.6);
        border-color: rgba(255, 255, 255, 0.3);
    }

    .trustpilot-right {
        width: 100%;
    }

    .trustpilot-card {
        background: linear-gradient(135deg, rgba(138, 43, 226, 0.15), rgba(255, 20, 147, 0.15));
        border: 2px solid rgba(255, 20, 147, 0.3);
        border-radius: 20px;
        padding: 40px;
        backdrop-filter: blur(10px);
        transition: all 0.3s ease;
        display: grid;
        grid-template-columns: auto 1fr;
        gap: 40px;
        align-items: center;
    }

    .rating-left {
        text-align: center;
        min-width: 160px;
    }

    .rating-score {
        font-size: 72px;
        font-weight: bold;
        color: #fff;
        line-height: 1;
        margin-bottom: 15px;
    }

    .rating-label {
        font-size: 24px;
        font-weight: 600;
        color: #fff;
        margin-bottom: 15px;
    }

    .rating-stars {
        display: flex;
        gap: 4px;
        justify-content: center;
        margin-bottom: 15px;
    }

    .rating-stars .star {
        color: #00b67a;
        font-size: 26px;
    }

    .rating-count {
        font-size: 16px;
        color: rgba(255, 255, 255, 0.7);
        font-weight: 500;
    }

    .rating-right {
        width: 100%;
    }

    .rating-bars {
        display: flex;
        flex-direction: column;
        gap: 14px;
    }

    .rating-bar {
        display: grid;
        grid-template-columns: 60px 1fr;
        align-items: center;
        gap: 15px;
    }

    .bar-label {
        color: rgba(255, 255, 255, 0.8);
        font-size: 15px;
        font-weight: 500;
    }

    .bar-container {
        width: 100%;
        height: 10px;
        background: rgba(255, 255, 255, 0.15);
        border-radius: 5px;
        overflow: hidden;
    }

    .bar-fill {
        height: 100%;
        border-radius: 5px;
        transition: width 0.6s ease;
    }

    .bar-fill.green { background: #00b67a; }
    .bar-fill.red { background: #ff3722; }

    @media (max-width: 1024px) {
        .trustpilot-container {
            grid-template-columns: 1fr;
            gap: 40px;
        }
        .trustpilot-right { max-width: 600px; margin: 0 auto; }
        .reviews-illustration { max-width: 500px; }
    }

    @media (max-width: 768px) {
        .trustpilot-section { padding: 40px 15px; }
        .trustpilot-card { grid-template-columns: 1fr; gap: 30px; padding: 30px 25px; }
        .rating-left { min-width: auto; padding-bottom: 25px; border-bottom: 2px solid rgba(255, 20, 147, 0.3); }
        .rating-score { font-size: 56px; }
        .rating-label { font-size: 20px; }
    }

    /* Telegram Section Refined Arrangement */
    .telegram-section-wrapper {
        background: var(--primary-gradient);
        border-radius: 30px;
        padding: 80px 40px;
        position: relative;
        overflow: hidden;
        margin: 60px 0;
        box-shadow: 0 20px 50px rgba(0, 0, 0, 0.2);
    }

    .telegram-section-wrapper::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: radial-gradient(circle at 10% 20%, rgba(255, 255, 255, 0.1) 0%, transparent 40%),
                    radial-gradient(circle at 90% 80%, rgba(255, 255, 255, 0.1) 0%, transparent 40%);
        pointer-events: none;
    }

    .telegram-badge {
        display: inline-flex;
        align-items: center;
        background: rgba(255, 255, 255, 0.15);
        backdrop-filter: blur(10px);
        padding: 8px 18px;
        border-radius: 50px;
        margin-right: 12px;
        margin-bottom: 12px;
        font-size: 14px;
        font-weight: 600;
        color: white;
        border: 1px solid rgba(255, 255, 255, 0.1);
    }
</style>

<!-- Hero Section -->
<section id="hero" class="hero-section">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6 hero-content fade-in">
                <h1 class="hero-title">
                    Your Gateway to
                    <br>
                    <span class="text-gradient">Easy Crypto</span> Rewards
                </h1>

                <p class="hero-subtitle">
                    Earn Free <span class="hero-highlight">PEPE, SHIB, BONK, FLOKI,</span> BTC, TRX, LTC, 10+
                    Different Coins and instant Cwallet & Faucetpay payouts!
                </p>

                <div class="d-flex flex-wrap gap-3 mt-4">
                    <a href="<?= site_url('register') ?>" class="btn-primary-custom">
                        <i class="fas fa-rocket me-2"></i>Start Earning
                    </a>
                    <a href="#methods" class="btn-outline-custom">
                        <i class="fas fa-play-circle me-2"></i>How It Works
                    </a>
                </div>
            </div>

            <div class="col-lg-6 hero-illustration slide-up" style="animation-delay: 0.2s">
                <img src="<?= base_url('assets/coinzi/home/img/hero-img.png') ?>" alt="Crypto Rewards" class="img-fluid">
            </div>
        </div>
    </div>
</section>

<!-- Trustpilot Section -->
<section class="trustpilot-section">
    <div class="trustpilot-container">
        <!-- Left Side - Illustration & Button -->
        <div class="trustpilot-left">
            <div class="reviews-illustration">
                <div class="illustration-icon">⭐</div>
                <div class="illustration-text">
                    <h3>Trusted by Customers</h3>
                    <p>Join hundreds of satisfied users who trust our platform for their cryptocurrency needs</p>
                </div>
            </div>

            <a href="https://www.trustpilot.com/review/coinzi.net" target="_blank" class="view-reviews-btn">
                View All Reviews →
            </a>
        </div>

        <!-- Right Side - Rating Card -->
        <div class="trustpilot-right">
            <div class="trustpilot-card">
                <div class="rating-left">
                    <div class="rating-score">4.8</div>
                    <div class="rating-label">Excellent</div>
                    <div class="rating-stars">
                        <span class="star">★</span><span class="star">★</span><span class="star">★</span><span class="star">★</span><span class="star">★</span>
                    </div>
                    <div class="rating-count">202 reviews</div>
                </div>

                <div class="rating-right">
                    <div class="rating-bars">
                        <div class="rating-bar">
                            <span class="bar-label">5-star</span>
                            <div class="bar-container"><div class="bar-fill green" style="width: 92%"></div></div>
                        </div>
                        <div class="rating-bar">
                            <span class="bar-label">4-star</span>
                            <div class="bar-container"><div class="bar-fill green" style="width: 5%"></div></div>
                        </div>
                        <div class="rating-bar">
                            <span class="bar-label">3-star</span>
                            <div class="bar-container"><div class="bar-fill green" style="width: 1%"></div></div>
                        </div>
                        <div class="rating-bar">
                            <span class="bar-label">2-star</span>
                            <div class="bar-container"><div class="bar-fill green" style="width: 1%"></div></div>
                        </div>
                        <div class="rating-bar">
                            <span class="bar-label">1-star</span>
                            <div class="bar-container"><div class="bar-fill red" style="width: 1%"></div></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Currencies Section -->
<section class="section">
    <div class="container">
        <h2 class="section-title fade-in">Supported <span class="text-gradient">Currencies</span></h2>
        <p class="section-subtitle fade-in">We support a wide range of cryptocurrencies for earning and withdrawal</p>

        <div class="currency-grid">
            <?php foreach($methods as $method) { ?>
            <div class="currency-item scale-in">
                <div class="currency-icon">
                    <img src="<?= base_url('assets/images/currencies/'.strtolower($method['code']).'.png') ?>" alt="<?= $method['name'] ?>" onerror="this.src='<?= base_url('assets/images/currencies/btc.png') ?>'">
                </div>
                <h6 class="mb-0 text-white"><?= $method['name'] ?></h6>
            </div>
            <?php } ?>
        </div>
    </div>
</section>

<!-- Telegram Section -->
<div class="container mb-5">
    <div class="telegram-section-wrapper px-4 px-lg-5">
        <div class="row align-items-center">
            <div class="col-lg-8 text-center text-lg-start">
                <h2 class="text-white mb-4 fw-bold">
                    <i class="fab fa-telegram me-3"></i>Join Our Telegram Hub
                </h2>
                <h4 class="text-white-50 mb-4 fw-normal">Daily Airdrops • Exclusive Rewards • Real-Time Support</h4>
                <p class="text-white mb-5 opacity-75 lead">Join our community to claim daily rewards and get instant support from our dedicated team.</p>

                <div class="mb-4 d-flex flex-wrap justify-content-center justify-content-lg-start">
                    <span class="telegram-badge"><i class="fas fa-gift me-2"></i>Daily Airdrops</span>
                    <span class="telegram-badge"><i class="fas fa-bolt me-2"></i>Instant Rewards</span>
                    <span class="telegram-badge"><i class="fas fa-users me-2"></i>Community Support</span>
                </div>

                <div class="d-flex flex-wrap justify-content-center justify-content-lg-start gap-3">
                    <a href="<?= $settings['telegram_url'] ?>" class="btn btn-light btn-lg px-4 py-3 rounded-pill fw-bold shadow-sm" target="_blank">
                        <i class="fab fa-telegram me-2"></i>Join Telegram Channel
                    </a>
                </div>
            </div>

            <div class="col-lg-4 text-center mt-5 mt-lg-0">
                <div class="qr-code bg-white p-3 rounded-4 d-inline-block shadow-lg hover-lift">
                    <img src="https://api.qrserver.com/v1/create-qr-code/?size=200x200&data=<?= $settings['telegram_url'] ?>" alt="Telegram QR Code" class="img-fluid" style="width: 180px;">
                    <p class="mt-3 mb-0 text-dark fw-bold small uppercase tracking-wider">Scan to Join</p>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Earning Methods -->
<section id="methods" class="section">
    <div class="container">
        <h2 class="section-title fade-in">Core <span class="text-gradient">Earning Methods</span></h2>
        <p class="section-subtitle fade-in">Multiple ways to earn cryptocurrency tailored to your preferences</p>

        <div class="row g-4 text-center">
            <div class="col-md-6 col-lg-4">
                <div class="feature-card slide-up hover-lift">
                    <div class="feature-icon mx-auto"><i class="fas fa-mouse-pointer"></i></div>
                    <h3 class="feature-title">PTC Ads</h3>
                    <p class="feature-description">Quick, simple, and reliable crypto earning by viewing advertisements</p>
                </div>
            </div>
            <div class="col-md-6 col-lg-4">
                <div class="feature-card slide-up hover-lift">
                    <div class="feature-icon mx-auto"><i class="fas fa-bullseye"></i></div>
                    <h3 class="feature-title">Offerwalls</h3>
                    <p class="feature-description">Targeted offers and tasks to maximize your earnings</p>
                </div>
            </div>
            <div class="col-md-6 col-lg-4">
                <div class="feature-card slide-up hover-lift">
                    <div class="feature-icon mx-auto"><i class="fas fa-faucet"></i></div>
                    <h3 class="feature-title">Faucet</h3>
                    <p class="feature-description">Easy, instant crypto claims every few hours</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Why Choose Us -->
<section id="features" class="section">
    <div class="container">
        <h2 class="section-title fade-in">Why <span class="text-gradient">Choose <?= $settings['name'] ?></span></h2>
        <p class="section-subtitle fade-in">Experience the difference with our premium features</p>

        <div class="row align-items-center">
            <div class="col-lg-6 mb-5 mb-lg-0">
                <img src="<?= base_url('assets/coinzi/home/img/why-us-img.png') ?>" alt="Why Choose Us" class="img-fluid rounded-4 shadow-large">
            </div>

            <div class="col-lg-6">
                <div class="feature-card mb-4 slide-up hover-lift">
                    <div class="d-flex align-items-start">
                        <div class="feature-icon me-3" style="min-width: 50px; height: 50px;"><i class="fas fa-bolt"></i></div>
                        <div>
                            <h4 class="feature-title">Instant Withdrawals</h4>
                            <p class="feature-description mb-0">Get paid instantly to your wallet with no waiting periods. We support multiple microwallets.</p>
                        </div>
                    </div>
                </div>
                <div class="feature-card mb-4 slide-up hover-lift" style="animation-delay: 0.1s">
                    <div class="d-flex align-items-start">
                        <div class="feature-icon me-3" style="min-width: 50px; height: 50px;"><i class="fas fa-shield-alt"></i></div>
                        <div>
                            <h4 class="feature-title">Secure Platform</h4>
                            <p class="feature-description mb-0">Your data and privacy are our top priorities. We use advanced security measures.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
