<div class="row">
    <div class="col-12">
        <div class="page-title-box">
            <div class="page-title-right">
                <a href="<?= site_url('admin/hugoffers') ?>" class="btn btn-outline-primary">
                    <i class="mdi mdi-arrow-left"></i> Back to Offers
                </a>
            </div>
            <h4 class="page-title">Add HugOffers Offer</h4>
        </div>
    </div>
</div>

<?php if ($this->session->flashdata('message')): ?>
    <?= $this->session->flashdata('message') ?>
<?php endif; ?>

<?php if (validation_errors()): ?>
    <div class="alert alert-danger">
        <?= validation_errors() ?>
    </div>
<?php endif; ?>

<div class="row">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-body">
                <h4 class="header-title mb-3">Offer Details</h4>
                
                <form action="<?= site_url('admin/hugoffers/add') ?>" method="POST">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label for="campid" class="form-label">Campaign ID <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="campid" name="campid" 
                                       value="<?= set_value('campid') ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label for="offer_name" class="form-label">Offer Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="offer_name" name="offer_name" 
                                       value="<?= set_value('offer_name') ?>" required>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group mb-3">
                                <label for="price" class="form-label">Price (USD) <span class="text-danger">*</span></label>
                                <input type="number" step="0.01" class="form-control" id="price" name="price" 
                                       value="<?= set_value('price') ?>" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group mb-3">
                                <label for="custom_payout" class="form-label">Custom Payout (USD)</label>
                                <input type="number" step="0.01" class="form-control" id="custom_payout" name="custom_payout" 
                                       value="<?= set_value('custom_payout') ?>">
                                <small class="text-muted">Override default price if needed</small>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group mb-3">
                                <label for="daily_cap" class="form-label">Daily Cap <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="daily_cap" name="daily_cap" 
                                       value="<?= set_value('daily_cap', 100) ?>" required>
                            </div>
                        </div>
                    </div>

                    <div class="form-group mb-3">
                        <label for="app_desc" class="form-label">Description</label>
                        <textarea class="form-control" id="app_desc" name="app_desc" rows="3"><?= set_value('app_desc') ?></textarea>
                    </div>

                    <div class="form-group mb-3">
                        <label for="preview_link" class="form-label">Preview/Download URL</label>
                        <input type="url" class="form-control" id="preview_link" name="preview_link" 
                               value="<?= set_value('preview_link') ?>">
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label for="platform" class="form-label">Platform</label>
                                <select class="form-control" id="platform" name="platform">
                                    <option value="All" <?= set_select('platform', 'All', true) ?>>All</option>
                                    <option value="Android" <?= set_select('platform', 'Android') ?>>Android</option>
                                    <option value="iOS" <?= set_select('platform', 'iOS') ?>>iOS</option>
                                    <option value="PC" <?= set_select('platform', 'PC') ?>>PC</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label for="app_category" class="form-label">Category</label>
                                <input type="text" class="form-control" id="app_category" name="app_category" 
                                       value="<?= set_value('app_category', 'General') ?>">
                            </div>
                        </div>
                    </div>

                    <div class="form-group mb-3">
                        <label for="icon_link" class="form-label">Icon URL</label>
                        <input type="url" class="form-control" id="icon_link" name="icon_link" 
                               value="<?= set_value('icon_link') ?>">
                    </div>

                    <input type="hidden" name="<?= $csrf_name ?>" value="<?= $csrf_hash ?>">
                    
                    <div class="text-end">
                        <button type="button" class="btn btn-secondary" onclick="history.back()">Cancel</button>
                        <button type="submit" class="btn btn-primary">Add Offer</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="col-lg-4">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Quick Add Tips</h5>
                <ul class="list-unstyled">
                    <li class="mb-2">
                        <i class="mdi mdi-check-circle text-success"></i>
                        Use the Campaign ID from HugOffers
                    </li>
                    <li class="mb-2">
                        <i class="mdi mdi-check-circle text-success"></i>
                        Set custom payout if different from default
                    </li>
                    <li class="mb-2">
                        <i class="mdi mdi-check-circle text-success"></i>
                        Add icon URL for better appearance
                    </li>
                    <li class="mb-2">
                        <i class="mdi mdi-information text-info"></i>
                        System will try to sync from API automatically
                    </li>
                </ul>

                <div class="alert alert-info">
                    <h6>Bulk Import Available</h6>
                    <p class="mb-2">For multiple offers, use the <a href="<?= site_url('admin/hugoffers/bulk_import') ?>" class="alert-link">Bulk Import</a> feature.</p>
                </div>
            </div>
        </div>
    </div>
</div> 