<?php

defined('BASEPATH') or exit('No direct script access allowed');

class M_Auth extends CI_Model
{
  public function multiple_account()
  {
    return false;
    $past = time() - 3600;
    $ip_address = $this->input->ip_address();
    $checkUser = $this->db->get_where('ip_addresses', array('ip_address' => $ip_address, 'last_use>' => $past))->num_rows();
    if ($checkUser > 0) {
      return true;
    }
    return false;
  }

  public function isCheater()
  {
    $past = time() - 86400;
    $ip_address = $this->input->ip_address();
    $check_user = $this->db->select('id')->from('users')->where(['ip_address' => $ip_address, 'last_active>' => $past])->get();
    if ($check_user->num_rows() > 1) {
      return $check_user->result_array();
    }
    return false;
  }

  /**
   * Generate a unique Telegram token (A-Z0-9), length 4..9.
   * Uses a retry loop + DB existence check (and relies on UNIQUE constraint as final authority).
   */
  private function generate_unique_telegram_token(int $minLen = 4, int $maxLen = 9, int $maxAttempts = 50): string
  {
    $alphabet = 'ABCDEFGHJKLMNPQRSTUVWXYZ23456789'; // avoids confusing chars (I,O,1,0) - optional
    $alphLen = strlen($alphabet);

    $minLen = max(4, $minLen);
    $maxLen = min(9, $maxLen);

    for ($attempt = 0; $attempt < $maxAttempts; $attempt++) {
      $len = random_int($minLen, $maxLen);

      $token = '';
      for ($i = 0; $i < $len; $i++) {
        $token .= $alphabet[random_int(0, $alphLen - 1)];
      }

      // Check if token exists
      $exists = $this->db->select('id')
        ->from('users')
        ->where('telegram_token', $token)
        ->limit(1)
        ->get()
        ->num_rows() > 0;

      if (!$exists) {
        return $token;
      }
    }

    // Extremely unlikely fallback: 9 chars derived from strong randomness
    // (still A-Z0-9, but longer "entropy" attempt)
    for ($attempt = 0; $attempt < $maxAttempts; $attempt++) {
      $len = 9;
      $token = '';
      for ($i = 0; $i < $len; $i++) {
        $token .= $alphabet[random_int(0, $alphLen - 1)];
      }

      $exists = $this->db->select('id')
        ->from('users')
        ->where('telegram_token', $token)
        ->limit(1)
        ->get()
        ->num_rows() > 0;

      if (!$exists) {
        return $token;
      }
    }

    // If we got here, something is seriously wrong (DB stuck, etc.)
    throw new Exception('Unable to generate unique telegram_token');
  }

  public function register($email, $username, $password, $active_keys, $isocode, $country, $ref, $referralSource, $status = 'active')
  {
    // Generate token before insert
    $tgToken = $this->generate_unique_telegram_token(4, 9);

    $user = array(
      'email' => $email,
      'username' => $username,
      'password' => $password,
      'ip_address' => $this->input->ip_address(),
      'isocode' => $isocode,
      'country' => $country,
      'referred_by' => $ref,
      'referral_source' => $referralSource,
      'telegram_token' => $tgToken,
      'telegram_verified' => 0, // ensure default
      'last_active' => time(),
      'joined' => time(),
      'last_firewall' => time(),
      'status' => $status
    );

    // Insert with collision-safe handling (in case two requests generate same token simultaneously)
    // If UNIQUE constraint blocks insert, retry a few times.
    for ($i = 0; $i < 10; $i++) {
      try {
        $this->db->insert('users', $user);
        return; // success
      } catch (Throwable $e) {
        // If duplicate key on telegram_token, regenerate and retry
        $errNo = (int)$this->db->error()['code'];
        if ($errNo === 1062) {
          $user['telegram_token'] = $this->generate_unique_telegram_token(4, 9);
          continue;
        }
        throw $e;
      }
    }

    throw new Exception('Registration failed: could not assign unique telegram_token after multiple attempts.');
  }

  public function updateUser($id)
  {
    $this->db->where('id', $id);
    $this->db->set('ip_address', $this->input->ip_address());
    $this->db->set('last_active', time());
    $this->db->set('last_firewall', time());
    $this->db->update('users');
  }

  public function login($email, $password)
  {
    $check = $this->db->get_where('users', array('email' => $email));
    if (!$check->num_rows()) {
      return false;
    }

    $user = $check->result_array()[0];
    if ($password == $user['password']) {
      $this->updateUser($user['id']);
      return $user;
    }
    return false;
  }

  public function valid_referral($id)
  {
    $check = $this->db->get_where('users', array('id' => $id))->num_rows();
    return $check == 1;
  }

  public function get_user_from_token($token)
  {
    $user = $this->db->get_where('users', array('secret' => $token));
    if ($user->num_rows() == 0) {
      return false;
    }
    return $user->result_array()[0];
  }

  public function update_password($user_id, $password)
  {
    $this->db->where('id', $user_id);
    $this->db->set('password', $password);
    $this->db->update('users');
  }

  public function insertForgotPassword($userId, $code)
  {
    $user = array(
      'user_id' => $userId,
      'code' => $code,
      'create_time' => time()
    );
    $this->db->insert('forgot_password', $user);
  }

  public function checkForgotPassword($code)
  {
    $check = $this->db->get_where('forgot_password', array('code' => $code));
    if ($check->num_rows() == 0) {
      return false;
    }
    $active = $check->result_array()[0];
    return $active;
  }

  public function getForgotPasswordByUserId($userId)
  {
    $check = $this->db->get_where('forgot_password', array('user_id' => $userId));
    if (!$check->num_rows()) {
      return false;
    }
    $active = $check->result_array()[0];
    return $active;
  }

  public function deleteForgotPassword($userId)
  {
    $this->db->delete('forgot_password', ['user_id' => $userId]);
  }
}
