<?php
defined('BASEPATH') or exit('No direct script access allowed');
class M_Active extends CI_Model
{
	public function getUser($activeKey)
	{
		$user = $this->db->get_where('users', array('secret' => $activeKey));
		if ($user->num_rows() == 0) {
			return false;
		}
		return $user->result_array()[0];
	}
	public function active($userId)
	{
		$this->db->where('id', $userId);
		$this->db->set('verified', 1);
		$this->db->update('users');
	}

// Pseudo-code in m_core.php or similar file

public function hasCompletedRequiredActivities($userId) {
    // Query the database to get the user's activity counts
    $userActivities = $this->db->get_where('users', array('id' => $userId))->row();
    
    // Check if the user meets the criteria
    return ($userActivities->shortlink_count >= $this->data['settings']['shortlink_contest'] &&
            $userActivities->offerwall_count >= $this->data['settings']['offerwall_contest']);
}

public function updateReferralCount($userId)
{
    // Update referral count in the users table
    $this->db->where('id', $userId);
    $this->db->set('ref_count', 'ref_count+1', FALSE);
    $this->db->update('users');

    // Check if user already exists in invites
    $query = $this->db->get_where('invites', ['user_id' => $userId]);

    if ($query->num_rows() > 0) {
        // If exists, update referral count
        $this->db->where('user_id', $userId);
        $this->db->set('referral', 'referral+1', FALSE);
        $this->db->update('invites');
    } else {
        // If not exists, insert a new row
        $data = [
            'user_id'  => $userId,
            'referral' => 1  // Start with 1 referral
        ];
        $this->db->insert('invites', $data);
    }
}

	public function insertActive($userId, $code)
	{
		$user = array(
			'user_id' => $userId,
			'code' => $code,
			'create_time' => time()
		);
		$this->db->insert('actives', $user);
	}

	public function checkActive($code)
	{
		$check = $this->db->get_where('actives', array('code' => $code));
		if (!$check->num_rows()) {
			return false;
		}
		$active = $check->result_array()[0];
		return $active;
	}

	public function getActiveByUserId($userId)
	{
		$check = $this->db->get_where('actives', array('user_id' => $userId));
		if (!$check->num_rows()) {
			return false;
		}
		$active = $check->result_array()[0];
		return $active;
	}
}
