<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Test extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
    }

    public function clickid()
    {
        // Test the click ID extraction logic
        $testClickIds = [
            '16_10317_1754037873_9512',
            '16_10345_1754020929_7031',
            '16_10345_1754036309_8458',
            'invalid_click_id'
        ];

        echo "<h2>Click ID Extraction Test</h2>";
        
        foreach ($testClickIds as $clickId) {
            $userId = $this->extractUserIdFromClickId($clickId);
            echo "<p><strong>Click ID:</strong> {$clickId} → <strong>User ID:</strong> " . ($userId !== null ? $userId : 'null') . "</p>";
        }
    }

    private function extractUserIdFromClickId($clickId) {
        // Extract user ID from click ID format: userId_offerId_timestamp_random
        $parts = explode('_', $clickId);
        
        if (count($parts) >= 4 && is_numeric($parts[0])) {
            return intval($parts[0]);
        }
        
        return null;
    }

    public function webhook_simulate()
    {
        // Simulate a webhook call
        echo "<h2>Webhook Simulation</h2>";
        
        // Simulate the $_REQUEST parameters
        $_REQUEST['aff_sub'] = '16_10317_1754037873_9512';
        $_REQUEST['offer_id'] = '10317';
        $_REQUEST['payout'] = '0.30';
        $_REQUEST['ip'] = '202.52.40.14';
        
        echo "<p><strong>Simulated Parameters:</strong></p>";
        echo "<pre>" . json_encode($_REQUEST, JSON_PRETTY_PRINT) . "</pre>";
        
        // Test extraction
        $clickId = $_REQUEST['aff_sub'];
        $userId = $this->extractUserIdFromClickId($clickId);
        
        echo "<p><strong>Extraction Result:</strong></p>";
        echo "<p>Click ID: {$clickId}</p>";
        echo "<p>User ID: " . ($userId !== null ? $userId : 'null') . "</p>";
        
        if ($userId) {
            echo "<p style='color: green;'>✅ User ID extraction successful!</p>";
        } else {
            echo "<p style='color: red;'>❌ User ID extraction failed!</p>";
        }
    }
} 