<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Daily_streak extends Member_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('m_daily_streak');
        $this->load->model('m_account'); // reward handling
    }

public function index()
{
    $user_id = $this->data['user']['id'];
    $streak = $this->m_daily_streak->get_streak($user_id);
    $rewards = $this->m_daily_streak->get_rewards($user_id);  // normal rewards

    // Get highest reward
    $max_reward = $this->m_daily_streak->get_max_reward();
    
    // Get lowest reward
    $min_reward = $this->m_daily_streak->get_min_reward();

    $this->data['page'] = 'Daily Streak';
    $this->data['streak'] = $streak;
    $this->data['rewards'] = $rewards;
    $this->data['min_reward'] = $min_reward;
    $this->data['max_reward'] = $max_reward;
    $this->data['csrf_name'] = $this->security->get_csrf_token_name();
    $this->data['csrf_hash'] = $this->security->get_csrf_hash();
    $this->data['day7_probs'] = $this->m_daily_streak->get_day7_probabilities();

    $this->render('daily_streak', $this->data);
}

public function claim()
{
    $user_id = $this->data['user']['id'];
    $user    = $this->db->get_where('users', ['id' => $user_id])->row_array(); 

    // Get minimum required earnings
    $required_earnings = $this->db
        ->get_where('settings', ['name' => 'req_earnings'])
        ->row('value') ?? 0;

    if (!$user || $user['earned_today'] < $required_earnings) {
        $this->session->set_flashdata('sweet_alert', [
            'title' => "Not enough activity",
            'text'  => "You must earn at least " 
                . currencyDisplay($required_earnings, $this->data['settings']) 
                . " today before claiming your streak.",
            'icon'  => 'warning'
        ]);
        return redirect('daily_streak');
    }

    $streak = $this->m_daily_streak->claim_streak($user_id);

    if ($streak) {
        $reward_row = $this->db->get_where('daily_streaks', ['day' => $streak['current_day']])->row_array();
        $reward = $reward_row['reward'] ?? 5;

        $this->m_core->rewardUser(
            $this->data['user'],
            'daily_streak',
            $reward,
            0,
            0,
            0
        );

        $this->session->set_flashdata('sweet_alert', [
            'title' => "Day {$streak['current_day']} Claimed!",
            'text'  => currencyDisplay($reward, $this->data['settings']) . ' has been added to your balance',
            'icon'  => 'success'
        ]);
    } else {
        $this->session->set_flashdata('sweet_alert', [
            'title' => "Already Claimed",
            'text'  => "You have already claimed today's reward.",
            'icon'  => 'info'
        ]);
    }

    redirect('daily_streak');
}

}