<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Contest extends Member_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('m_leaderboard');
	}
	public function index()
	{
		$this->data['page'] = 'Contest';
		$this->data['leaderboardSettings'] = $this->m_leaderboard->getSettings();

		$contestInfo = $this->cache->get('contest_info');
		if (!$contestInfo) {
			$contestInfo = [
				'topReferral' => $this->m_leaderboard->getTopReferral($this->data['settings']['admin_username'], $this->data['leaderboardSettings']['referral_contest_requirement'], $this->data['leaderboardSettings']['referral_contest_amount'])
			];
			$this->cache->save('contest_info', $contestInfo, 600);
		}
		$this->data = array_merge($this->data, $contestInfo);
		$this->render('contest', $this->data);
	}
}
