<div class="row section px-3">
    <div class="col-lg-12">
        <div class="ads">
            <?= $settings['links_top_ad'] ?>
        </div>
        <?php
        if (isset($_SESSION['message'])) {
            echo $_SESSION['message'];
        }
        ?>
    </div>
</div>

<!-- card sm -->
<div class="row section px-3 align-items-center">
    <div class="col-md-6 col-xl-4">
        <div class="card-sm">
            <!-- card text -->
            <div class="card-sm-text">
                <h2><?= $countAvailableLinks ?></h2>
                <p>Links available</p>
            </div>

            <!-- card icon -->
            <div class="icon">
                <img src="<?= base_url() ?>assets/coinzi/dash/img/link.png" alt="">
            </div>
        </div>
    </div>

    <div class="col-md-6 col-xl-4">
        <div class="card-sm">
            <!-- card text -->
            <div class="card-sm-text">
                <h2><?= currencyDisplay($totalReward, $settings) ?></h2>
                <p><?= currencyUnit($totalReward, $settings) ?></p>
            </div>

            <!-- card icon -->
            <div class="icon">
                <img src="<?= base_url() ?>assets/coinzi/dash/img/gift.png" alt="">
            </div>
        </div>
    </div>

    <div class="col-md-6 col-xl-4">
        <div class="card-sm deposit">
            <!-- card text -->
            <div class="card-sm-text">
                <h2><?= $totalEnergy ?></h2>
                <p>Energy</p>
            </div>

            <!-- card icon -->
            <div class="icon">
                <img src="<?= base_url() ?>assets/coinzi/dash/img/energy.png" alt="">
            </div>
        </div>
    </div>
</div>


<div class="row section px-3">
    <?php
    foreach ($availableLinks as $link) { ?>
        <div class="col-lg-6 col-xl-4">
                <div class="card-lg claim-card">
                  <h5 class="title"><?= $link['name'] ?></h5>

                  <div class="pill-wrap">
                    <div class="pill purple">
                      <i class="fa-solid fa-coins"></i>
                      <?= currencyDisplay($link['reward'], $settings) ?>
                    </div>

                    <div class="pill yellow">
                      <i class="fa-solid fa-bolt"></i>
                      <?= $link['energy'] ?>
                    </div>
                  </div>

                  <?php if ($link['rmnViews'] > 0) { ?>
                    <a href="<?= base_url() . 'links/go/' . $link['id'] ?>" target="_blank" class="btn-one">Claim <span class="badge badge-info"><?= $link['rmnViews'] ?>/<?= $link['view_per_day'] ?></span></a>
                <?php } else { ?>
                    <button class="btn-one" disabled>Claim <span class="badge badge-info"><?= $link['rmnViews'] ?>/<?= $link['view_per_day'] ?></span></button>
                <?php } ?>
                </div>
              </div>
    <?php } ?>
</div>
<?php if (!count($availableLinks)) {
    echo '<div class="mx-3 alert alert-warning text-center">There is no link left <i class="far fa-sad-cry fa-2x"></i> <i class="far fa-sad-cry fa-2x"></i> <i class="far fa-sad-cry fa-2x"></i></div>';
}
?>
<div class="ads">
    <?= $settings['links_footer_ad'] ?>
</div>