<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="<?= $settings['description'] ?>" name="description" />
    <link rel="shortcut icon" href="<?= base_url() ?>assets/images/favicon.ico">

    <!-- ##########  bootstrap stylesheet ########## -->
    <link href="<?= base_url() ?>assets/coinzi/bs/css/bootstrap.min.css" rel="stylesheet" crossorigin="anonymous">

    <!-- ##########  boxicon  ########## -->
    <link href='https://unpkg.com/boxicons@2.0.7/css/boxicons.min.css' rel='stylesheet'>

    <!-- aqua checkbox -->


    <!-- ##########  main stylesheet ########## -->
    <link rel="stylesheet" href="<?= base_url() ?>assets/coinzi/auth/css/auth.css">

    <title>Reset | <?= $settings['name'] ?> - <?= $settings['description'] ?></title>
</head>

<body>
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="content-wrap mx-auto">

                    <!-- site name -->
                    <div class="site-name text-center mb-5">
                        <h1>Reset Password</h1>
                    </div>

                    <?php
                                if (isset($_SESSION['message'])) {
                                    echo $_SESSION['message'];
                                }
                                ?>

                    <!-- form -->
                    <form action="<?= site_url('auth/forgot_password') ?>" method="POST">
                    <input type="hidden" name="<?= $csrf_name ?>" value="<?= $csrf_hash ?>">
                        <!-- mail -->
                        <div class="form-group mb-4 position-relative">
                            <input class="form-control" type="email" name="email" id="email" placeholder="Enter email">

                            <!-- mail icon -->
                            <div class="input-icon"><i class='bx bx-mail-send'></i></div>
                        </div>

                        <center>
                                        <?= $captcha_display ?>
                                    </center>

                        <!-- submit button -->
                        <button class="btn-one-fill w-100" type="submit">Reset</button>
                    </form>

                    <!-- extra link -->
                    <p class="text-center extra-link">
                        <a href="<?= site_url('login') ?>" class="small-link underline me-3">Sign In</a>
                        <a href="<?= site_url('register') ?>" class="small-link underline">Sign up</a>
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- gradient -->
    <div class="hero-gr-top">
        <img src="<?= base_url() ?>assets/coinzi/auth/img/hero-bg-gradient-top.svg" alt="">
    </div>

    <?= $settings['footer_code'] ?>

    <!-- JAVASCRIPT -->
    <script src="<?= base_url() ?>assets/libs/jquery/jquery.min.js"></script>
    <script src="<?= base_url() ?>assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="<?= base_url() ?>assets/libs/metismenu/metisMenu.min.js"></script>
    <script src="<?= base_url() ?>assets/libs/simplebar/simplebar.min.js"></script>
    <script src="<?= base_url() ?>assets/libs/node-waves/waves.min.js"></script>
    <script src="<?= base_url() ?>assets/js/vie/captcha.js?v=<?= VIE_VERSION ?>"></script>

    <!-- App js -->
    <script src="<?= base_url() ?>assets/js/app.js?v=<?= VIE_VERSION ?>"></script>
</body>

</html>