<div class="ads">
    <?= $settings['shortlinks_top_ad'] ?? '' ?>
</div>

<div>
    <?php
    if (isset($_SESSION['message'])) {
        echo $_SESSION['message'];
    }
    ?>
    
    <!-- Debug Information (only visible to admins) -->
    <?php if ($this->session->userdata('role') == 'administrator' && isset($bitcotasks_error)): ?>
    <div class="mx-3 alert alert-info">
        <h5>Debug Information (Admin Only)</h5>
        <p>API URL: <?= isset($debug_url) ? $debug_url : 'Not available' ?></p>
        <p>Response: <?= isset($debug_response) ? htmlspecialchars(substr($debug_response, 0, 500)) . (strlen($debug_response) > 500 ? '...' : '') : 'No response' ?></p>
        <p>Error: <?= $bitcotasks_error ?></p>
    </div>
    <?php endif; ?>
    
    <!-- BitcoTasks Shortlinks -->
    <?php if (isset($bitcotasks_sl) && count($bitcotasks_sl) > 0): ?>
    <div class="row section px-3">
        <?php foreach ($bitcotasks_sl as $sl): ?>
            <div class="col-lg-6 col-xl-4">
                <div class="card-lg claim-card">
                  <h5 class="title"><?= $sl['title'] ?></h5>

                  <div class="pill-wrap">
                    <div class="pill purple">
                      <i class="fa-solid fa-coins"></i>
                      <?= $sl['reward'] ?> <?= $sl['currency_name'] ?>
                    </div>
                    
                    <div class="pill yellow">
                      <i class="fa-solid fa-check-circle"></i>
                      <?= $sl['completion_rate'] ?>%
                    </div>
                    
                    <div class="pill blue">
                      <i class="fa-solid fa-sync"></i>
                      <?= $sl['available'] ?>/<?= $sl['limit'] ?>
                    </div>
                    
                    <?php if ($sl['boosted_campaign']): ?>
                    <div class="pill green">
                      <i class="fa-solid fa-rocket"></i>
                      Boosted
                    </div>
                    <?php endif; ?>
                  </div>
                  
                  <div class="mt-3">
                    <div class="progress mb-2" style="height: 10px;">
                      <div class="progress-bar bg-success" role="progressbar" style="width: <?= $sl['completion_rate'] ?>%;" 
                           aria-valuenow="<?= $sl['completion_rate'] ?>" aria-valuemin="0" aria-valuemax="100"></div>
                    </div>
                  </div>

                  <button onclick="window.location = '<?= $sl['url'] ?>'" class="btn-one">Visit Now</button>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
    <?php endif; ?>
    
    <?php if (isset($bitcotasks_error)): ?>
        <div class="mx-3 alert alert-danger text-center">
            <p>BitcoTasks Error: <?= $bitcotasks_error ?></p>
            <p><small>Please contact the administrator if this problem persists.</small></p>
        </div>
    <?php endif; ?>
    
    <?php if (!isset($bitcotasks_sl) || !count($bitcotasks_sl)): ?>
        <div class="mx-3 alert alert-warning text-center">There are no Shortlinks available <i class="far fa-sad-cry fa-2x"></i> <i class="far fa-sad-cry fa-2x"></i> <i class="far fa-sad-cry fa-2x"></i></div>
    <?php endif; ?>
</div>

<div class="ads">
    <?= $settings['shortlinks_footer_ad'] ?? '' ?>
</div>
