<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title mb-4"><?= $page ?></h4>
                <?php
                if (isset($_SESSION['message'])) {
                    echo $_SESSION['message'];
                }
                ?>
                <div class="table-responsive">
                    <table class="table table-striped" style="font-size: 10px;">
                        <thead>
                            <tr>
                                <th scope="col">Offer ID</th>
                                <th scope="col">User</th>
                                <th scope="col">Ip Address</th>
                                <th scope="col">Company</th>
                                <th scope="col">Offer Name</th>
                                <th scope="col">Amount</th>
                                <th scope="col">Payout</th>
                                <th scope="col">Finished At</th>
                                <th scope="col">Action</th>
                            </tr>
                        </thead>
                        <tbody style="font-size: 10px;">
                            <?php foreach ($records as $record) { ?>
                                <tr>
                                    <th scope="row"><?= $record['id'] ?></th>
                                    <td><a target="_blank" href="<?= site_url("/admin/users/details/" . $record['user_id']) ?>"><?= $record['username'] ?> <?= ($record['isocode'] != 'N/A') ? '<img src="' . base_url() . 'assets/images/flags/' . $record['isocode'] . '.png" title="' . $record['country'] . '">' : '' ?></td>
                                    <td><a target="_blank" href="https://www.ipqualityscore.com/free-ip-lookup-proxy-vpn-test/lookup/<?= $record['ip_address'] ?>"><?= $record['ip_address'] ?></a></td>
                                    <td><?= ucfirst($record['offerwall']) ?></td>
                                    <td><?= ucfirst($record['offer_name']) ?></td>
                                    <td><?= format_money($record['amount']) ?></td>
                                    <td><?= format_money($record['payout']) ?></td>
                                    <td><?= timespan($record["claim_time"], time(), 2) ?> ago</td>
                                    <td> <a class="btn btn-success btn-sm" href="<?= site_url('admin/accept_offerwall/' . $record['id']) ?>">Accept</a> | <a class="bn btn-danger btn-sm" href="<?= site_url('admin/deny_offerwall/' . $record['id']) ?>">Deny</a> </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
                <?= $pagination ?>
            </div>
        </div>
    </div>
</div>