<?php
defined('BASEPATH') or exit('No direct script access allowed');
class M_referral_milestones extends CI_Model
{

	public function get()
	{
		return $this->db->get('ref_milestones')->result_array();
	}

	public function update($id, $condition, $reward_usd)
	{
		$this->db->where('id', $id);
		$this->db->set('condition', $condition);
		$this->db->set('reward_usd', $reward_usd);
		$this->db->update('ref_milestones');
	}
	public function add($condition, $reward_usd)
	{
		$insert = array(
			'condition' => $condition,
			'reward_usd' => $reward_usd,
		);
		$this->db->insert('ref_milestones', $insert);
	}

public function getMilestones($userId)
{
    return $this->db->query("
        SELECT m.*, 
               h.user_id AS claimed_user, 
               h.claim_time
        FROM ref_milestones m
        LEFT JOIN ref_milestones_history h 
            ON m.id = h.milestone_id AND h.user_id = " . (int) $userId . "
        ORDER BY m.condition ASC
    ")->result_array();
}

	public function checkHistory($milestoneId, $userId)
	{
		$check = $this->db->query('SELECT COUNT(*) AS cnt FROM ref_milestones_history WHERE user_id=' . $userId . ' AND milestone_id=' . $milestoneId)->result_array()[0]['cnt'];
		return $check == 0;
	}
	public function updateUser($id, $amount)
	{
		$this->db->where('id', $id);
		$this->db->set('balance', 'balance+' . $amount, FALSE);
		$this->db->set('total_earned', 'total_earned+' . $amount, FALSE);
		$this->db->set('last_active', time());
		$this->db->update('users');
	}

	public function getMilestoneFromId($id)
	{
		$milestone = $this->db->get_where('ref_milestones', array('id' => $id));
		if ($milestone->num_rows() == 0) {
			return false;
		}
		return $milestone->result_array()[0];
	}

	public function insertHistory($userId, $milestoneId, $amount)
	{
		$insert = array(
			'milestone_id' => $milestoneId,
			'user_id' => $userId,
			'amount' => $amount,
			'claim_time' => time()
		);
		$this->db->insert('ref_milestones_history', $insert);
	}
}
