<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Referral_milestones extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library('form_validation');
        $this->load->model('m_referral_milestones');
    }

    public function index()
    {
        $this->data['page'] = 'Referral Milestones Settings';
        $this->data['milestones'] = $this->m_referral_milestones->get();
        $this->render('referral_milestones', $this->data);
    }
    public function add()
    {
        $condition = $this->db->escape_str($this->input->post('condition'));
        $rewardUsd = $this->db->escape_str($this->input->post('reward_usd'));
        $this->m_referral_milestones->add($condition, $rewardUsd);
        redirect(site_url('admin/referral_milestones'));
    }
    public function edit($id)
    {
        $type = $this->db->escape_str($this->input->post('type'));
        $condition = $this->db->escape_str($this->input->post('condition'));
        $rewardUsd = $this->db->escape_str($this->input->post('reward_usd'));
        $this->m_referral_milestones->update($id, $type, $condition, $rewardUsd);
        redirect(site_url('admin/referral_milestones'));
    }
    public function delete($id = 0)
    {
        $this->db->delete('ref_milestones', array('id' => $id));
        redirect(site_url('admin/referral_milestones'));
    }
}
