<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Daily_streak extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library('form_validation');
        $this->load->model('m_daily_streak');
    }

public function index()
{
    $this->data['page'] = 'Daily Streak Settings';
    $this->data['daily_streaks'] = $this->m_daily_streak->get();
    $this->data['req_earnings'] = $this->m_daily_streak->get_req_earnings(); // load setting
    $this->render('daily_streak', $this->data);
}

public function update_req_earnings()
{
    $req_earnings = $this->db->escape_str($this->input->post('req_earnings'));
    $this->m_daily_streak->update_req_earnings($req_earnings);

    $_SESSION['message'] = '<div class="alert alert-success">Required earnings updated successfully!</div>';
    redirect(site_url('admin/daily_streak'));
}
    public function add()
    {
        $day = 7;
        $rewardUsd = $this->db->escape_str($this->input->post('reward_usd'));
        $weight = $this->db->escape_str($this->input->post('weight'));
        $this->m_daily_streak->add($day, $rewardUsd, $weight);
        redirect(site_url('admin/daily_streak'));
    }
    public function edit($id)
    {
        $rewardUsd = $this->db->escape_str($this->input->post('reward_usd'));
        $weight = $this->db->escape_str($this->input->post('weight'));
        $this->m_daily_streak->update($id, $rewardUsd, $weight);
        redirect(site_url('admin/daily_streak'));
    }
    
    public function delete($id = 0)
    {
        $this->db->delete('daily_streaks', array('id' => $id));
        redirect(site_url('admin/daily_streak'));
    }
}
